"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.throttlingFormatter = exports.browserFormatters = void 0;
var _monitor_defaults = require("../../../../common/constants/monitor_defaults");
var _runtime_types = require("../../../../common/runtime_types");
var _common = require("./common");
var _tls = require("./tls");
var _formatting_utils = require("./formatting_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const throttlingFormatter = fields => {
  var _thValue$download, _thValue$upload, _thValue$latency;
  const value = fields[_runtime_types.ConfigKey.THROTTLING_CONFIG];
  const defaultThrottling = _monitor_defaults.DEFAULT_BROWSER_ADVANCED_FIELDS[_runtime_types.ConfigKey.THROTTLING_CONFIG].value;
  const thValue = value === null || value === void 0 ? void 0 : value.value;
  if (!thValue || !defaultThrottling) return false;
  if ((thValue === null || thValue === void 0 ? void 0 : thValue.download) === '0' && (thValue === null || thValue === void 0 ? void 0 : thValue.upload) === '0' && (thValue === null || thValue === void 0 ? void 0 : thValue.latency) === '0') return false;
  if ((value === null || value === void 0 ? void 0 : value.label) === 'no-throttling') return false;
  return {
    download: Number((_thValue$download = thValue === null || thValue === void 0 ? void 0 : thValue.download) !== null && _thValue$download !== void 0 ? _thValue$download : defaultThrottling.download),
    upload: Number((_thValue$upload = thValue === null || thValue === void 0 ? void 0 : thValue.upload) !== null && _thValue$upload !== void 0 ? _thValue$upload : defaultThrottling.upload),
    latency: Number((_thValue$latency = thValue === null || thValue === void 0 ? void 0 : thValue.latency) !== null && _thValue$latency !== void 0 ? _thValue$latency : defaultThrottling.latency)
  };
};
exports.throttlingFormatter = throttlingFormatter;
const browserFormatters = {
  ..._common.commonFormatters,
  ..._tls.tlsFormatters,
  [_runtime_types.ConfigKey.SOURCE_PROJECT_CONTENT]: null,
  [_runtime_types.ConfigKey.SCREENSHOTS]: null,
  [_runtime_types.ConfigKey.IGNORE_HTTPS_ERRORS]: null,
  [_runtime_types.ConfigKey.TEXT_ASSERTION]: null,
  [_runtime_types.ConfigKey.PORT]: null,
  [_runtime_types.ConfigKey.URLS]: null,
  [_runtime_types.ConfigKey.METADATA]: _formatting_utils.objectFormatter,
  [_runtime_types.ConfigKey.SOURCE_INLINE]: null,
  [_runtime_types.ConfigKey.THROTTLING_CONFIG]: throttlingFormatter,
  [_runtime_types.ConfigKey.JOURNEY_FILTERS_MATCH]: null,
  [_runtime_types.ConfigKey.SYNTHETICS_ARGS]: _formatting_utils.arrayFormatter,
  [_runtime_types.ConfigKey.JOURNEY_FILTERS_TAGS]: _formatting_utils.arrayFormatter,
  [_runtime_types.ConfigKey.PLAYWRIGHT_OPTIONS]: _formatting_utils.stringToObjectFormatter,
  [_runtime_types.ConfigKey.JOURNEY_FILTERS_TAGS]: _formatting_utils.arrayFormatter,
  [_runtime_types.ConfigKey.PLAYWRIGHT_OPTIONS]: _formatting_utils.stringToObjectFormatter
};
exports.browserFormatters = browserFormatters;