"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.commonFormatters = void 0;
var _runtime_types = require("../../../../common/runtime_types");
var _formatting_utils = require("./formatting_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const commonFormatters = {
  [_runtime_types.ConfigKey.APM_SERVICE_NAME]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.NAME]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.LOCATIONS]: null,
  [_runtime_types.ConfigKey.MONITOR_TYPE]: null,
  [_runtime_types.ConfigKey.ENABLED]: null,
  [_runtime_types.ConfigKey.ALERT_CONFIG]: null,
  [_runtime_types.ConfigKey.CONFIG_ID]: null,
  [_runtime_types.ConfigKey.NAMESPACE]: null,
  [_runtime_types.ConfigKey.REVISION]: null,
  [_runtime_types.ConfigKey.MONITOR_SOURCE_TYPE]: null,
  [_runtime_types.ConfigKey.FORM_MONITOR_TYPE]: null,
  [_runtime_types.ConfigKey.JOURNEY_ID]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.PROJECT_ID]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.CUSTOM_HEARTBEAT_ID]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.ORIGINAL_SPACE]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.CONFIG_HASH]: null,
  [_runtime_types.ConfigKey.MONITOR_QUERY_ID]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.PARAMS]: null,
  [_runtime_types.ConfigKey.SCHEDULE]: fields => {
    var _fields$ConfigKey$SCH, _fields$ConfigKey$SCH2;
    return JSON.stringify(`@every ${(_fields$ConfigKey$SCH = fields[_runtime_types.ConfigKey.SCHEDULE]) === null || _fields$ConfigKey$SCH === void 0 ? void 0 : _fields$ConfigKey$SCH.number}${(_fields$ConfigKey$SCH2 = fields[_runtime_types.ConfigKey.SCHEDULE]) === null || _fields$ConfigKey$SCH2 === void 0 ? void 0 : _fields$ConfigKey$SCH2.unit}`);
  },
  [_runtime_types.ConfigKey.TAGS]: _formatting_utils.arrayToJsonFormatter,
  [_runtime_types.ConfigKey.TIMEOUT]: _formatting_utils.secondsToCronFormatter,
  [_runtime_types.ConfigKey.MONITOR_SOURCE_TYPE]: fields => fields[_runtime_types.ConfigKey.MONITOR_SOURCE_TYPE] || _runtime_types.SourceType.UI
};
exports.commonFormatters = commonFormatters;