"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.triggerTestNow = exports.testNowMonitorRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _uuid = require("uuid");
var _saved_objects = require("../../../common/types/saved_objects");
var _runtime_types = require("../../../common/runtime_types");
var _constants = require("../../../common/constants");
var _secrets = require("../../synthetics_service/utils/secrets");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const testNowMonitorRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.TRIGGER_MONITOR + '/{monitorId}',
  validate: {
    params: _configSchema.schema.object({
      monitorId: _configSchema.schema.string({
        minLength: 1,
        maxLength: 1024
      })
    })
  },
  handler: async routeContext => {
    const {
      monitorId
    } = routeContext.request.params;
    return triggerTestNow(monitorId, routeContext);
  }
});
exports.testNowMonitorRoute = testNowMonitorRoute;
const triggerTestNow = async (monitorId, {
  server,
  spaceId,
  syntheticsMonitorClient
}) => {
  const encryptedClient = server.encryptedSavedObjects.getClient();
  const monitorWithSecrets = await encryptedClient.getDecryptedAsInternalUser(_saved_objects.syntheticsMonitorType, monitorId, {
    namespace: spaceId
  });
  const normalizedMonitor = (0, _secrets.normalizeSecrets)(monitorWithSecrets);
  const {
    [_runtime_types.ConfigKey.SCHEDULE]: schedule,
    [_runtime_types.ConfigKey.LOCATIONS]: locations
  } = monitorWithSecrets.attributes;
  const {
    syntheticsService
  } = syntheticsMonitorClient;
  const testRunId = (0, _uuid.v4)();
  const paramsBySpace = await syntheticsService.getSyntheticsParams({
    spaceId
  });
  const errors = await syntheticsService.runOnceConfigs({
    // making it enabled, even if it's disabled in the UI
    monitor: {
      ...normalizedMonitor.attributes,
      enabled: true
    },
    configId: monitorId,
    heartbeatId: normalizedMonitor.attributes[_runtime_types.ConfigKey.MONITOR_QUERY_ID],
    testRunId,
    params: paramsBySpace[spaceId]
  });
  if (errors && (errors === null || errors === void 0 ? void 0 : errors.length) > 0) {
    return {
      errors,
      testRunId,
      schedule,
      locations,
      configId: monitorId,
      monitor: normalizedMonitor.attributes
    };
  }
  return {
    testRunId,
    schedule,
    locations,
    configId: monitorId,
    monitor: normalizedMonitor.attributes
  };
};
exports.triggerTestNow = triggerTestNow;