"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLocationMonitors = void 0;
var _constants = require("../../../../common/constants");
var _saved_objects = require("../../../../common/types/saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const aggs = {
  locations: {
    terms: {
      field: `${_saved_objects.monitorAttributes}.locations.id`,
      size: 10000
    }
  }
};
const getLocationMonitors = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.PRIVATE_LOCATIONS_MONITORS,
  validate: {},
  handler: async ({
    savedObjectsClient: soClient
  }) => {
    var _locationMonitors$agg, _locationMonitors$agg2;
    const locationMonitors = await (soClient === null || soClient === void 0 ? void 0 : soClient.find({
      type: _saved_objects.syntheticsMonitorType,
      perPage: 0,
      aggs
    }));
    const payload = (_locationMonitors$agg = (_locationMonitors$agg2 = locationMonitors.aggregations) === null || _locationMonitors$agg2 === void 0 ? void 0 : _locationMonitors$agg2.locations.buckets.map(({
      key: id,
      doc_count: count
    }) => ({
      id,
      count
    }))) !== null && _locationMonitors$agg !== void 0 ? _locationMonitors$agg : [];
    return {
      options: {},
      payload,
      status: 200
    };
  }
});
exports.getLocationMonitors = getLocationMonitors;