"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteSyntheticsParamsRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _saved_objects = require("../../../common/types/saved_objects");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteSyntheticsParamsRoute = () => ({
  method: 'DELETE',
  path: _constants.SYNTHETICS_API_URLS.PARAMS,
  validate: {
    query: _configSchema.schema.object({
      ids: _configSchema.schema.string()
    })
  },
  writeAccess: true,
  handler: async ({
    savedObjectsClient,
    request
  }) => {
    const {
      ids
    } = request.query;
    const parsedIds = JSON.parse(ids);
    const result = await savedObjectsClient.bulkDelete(parsedIds.map(id => ({
      type: _saved_objects.syntheticsParamType,
      id
    })), {
      force: true
    });
    return {
      data: result
    };
  }
});
exports.deleteSyntheticsParamsRoute = deleteSyntheticsParamsRoute;