"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllSyntheticsMonitorRoute = void 0;
var _constants = require("../../../common/constants");
var _common = require("../common");
var _saved_objects = require("../../../common/types/saved_objects");
var _helper = require("./helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAllSyntheticsMonitorRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.SYNTHETICS_MONITORS,
  validate: {
    query: _common.QuerySchema
  },
  handler: async routeContext => {
    var _totalCount$total;
    const {
      request,
      savedObjectsClient,
      syntheticsMonitorClient
    } = routeContext;
    const totalCountQuery = async () => {
      if ((0, _common.isMonitorsQueryFiltered)(request.query)) {
        return savedObjectsClient.find({
          type: _saved_objects.syntheticsMonitorType,
          perPage: 0,
          page: 1
        });
      }
    };
    const [queryResultSavedObjects, totalCount] = await Promise.all([(0, _common.getMonitors)(routeContext), totalCountQuery()]);
    const absoluteTotal = (_totalCount$total = totalCount === null || totalCount === void 0 ? void 0 : totalCount.total) !== null && _totalCount$total !== void 0 ? _totalCount$total : queryResultSavedObjects.total;
    const {
      saved_objects: savedObjects,
      per_page: perPageT,
      ...rest
    } = queryResultSavedObjects;
    return {
      ...rest,
      monitors: savedObjects.map(_helper.mapSavedObjectToMonitor),
      absoluteTotal,
      perPage: perPageT,
      syncErrors: syntheticsMonitorClient.syntheticsService.syncErrors
    };
  }
});
exports.getAllSyntheticsMonitorRoute = getAllSyntheticsMonitorRoute;