"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSyntheticsTLSCheckRule = void 0;
var _server = require("@kbn/rule-registry-plugin/server");
var _std = require("@kbn/std");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _common = require("@kbn/observability-plugin/common");
var _configSchema = require("@kbn/config-schema");
var _translations = require("../../../common/rules/synthetics/translations");
var _field_names = require("../../../common/field_names");
var _message_utils = require("./message_utils");
var _tls_rule_executor = require("./tls_rule_executor");
var _synthetics_alerts = require("../../../common/constants/synthetics_alerts");
var _common2 = require("../common");
var _action_variables = require("../action_variables");
var _action_variables2 = require("../../legacy_uptime/lib/alerts/action_variables");
var _common3 = require("../../legacy_uptime/lib/alerts/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSyntheticsTLSCheckRule = (server, libs, plugins, syntheticsMonitorClient, ruleDataClient) => {
  const createLifecycleRuleType = (0, _server.createLifecycleRuleTypeFactory)({
    ruleDataClient,
    logger: server.logger
  });
  return createLifecycleRuleType({
    id: _synthetics_alerts.SYNTHETICS_ALERT_RULE_TYPES.TLS,
    producer: 'uptime',
    name: _synthetics_alerts.TLS_CERTIFICATE.name,
    validate: {
      params: _configSchema.schema.object({
        search: _configSchema.schema.maybe(_configSchema.schema.string()),
        certExpirationThreshold: _configSchema.schema.maybe(_configSchema.schema.number()),
        certAgeThreshold: _configSchema.schema.maybe(_configSchema.schema.number())
      })
    },
    defaultActionGroupId: _synthetics_alerts.TLS_CERTIFICATE.id,
    actionGroups: [_synthetics_alerts.TLS_CERTIFICATE],
    actionVariables: (0, _action_variables.getActionVariables)({
      plugins
    }),
    isExportable: true,
    minimumLicenseRequired: 'basic',
    doesSetRecoveryContext: true,
    async executor({
      state,
      params,
      services,
      spaceId,
      previousStartedAt,
      startedAt
    }) {
      const ruleState = state;
      const {
        basePath,
        share
      } = server;
      const alertsLocator = share.url.locators.get(_common.alertsLocatorID);
      const {
        alertFactory,
        getAlertUuid,
        savedObjectsClient,
        scopedClusterClient,
        alertWithLifecycle,
        getAlertStartedDate
      } = services;
      const tlsRule = new _tls_rule_executor.TLSRuleExecutor(previousStartedAt, params, savedObjectsClient, scopedClusterClient.asCurrentUser, server, syntheticsMonitorClient);
      const {
        foundCerts,
        certs,
        absoluteExpirationThreshold,
        absoluteAgeThreshold,
        latestPings
      } = await tlsRule.getExpiredCertificates();
      await (0, _std.asyncForEach)(certs, async cert => {
        var _getAlertStartedDate;
        const summary = (0, _message_utils.getCertSummary)(cert, absoluteExpirationThreshold, absoluteAgeThreshold);
        if (!summary.summary || !summary.status) {
          return;
        }
        const alertId = cert.sha256;
        const alertUuid = getAlertUuid(alertId);
        const indexedStartedAt = (_getAlertStartedDate = getAlertStartedDate(alertId)) !== null && _getAlertStartedDate !== void 0 ? _getAlertStartedDate : startedAt.toISOString();
        const alertInstance = alertWithLifecycle({
          id: alertId,
          fields: {
            [_field_names.CERT_COMMON_NAME]: cert.common_name,
            [_field_names.CERT_ISSUER_NAME]: cert.issuer,
            [_field_names.CERT_VALID_NOT_AFTER]: cert.not_after,
            [_field_names.CERT_VALID_NOT_BEFORE]: cert.not_before,
            [_field_names.CERT_HASH_SHA256]: cert.sha256,
            [_ruleDataUtils.ALERT_UUID]: alertUuid,
            [_ruleDataUtils.ALERT_REASON]: (0, _common3.generateAlertMessage)(_translations.TlsTranslations.defaultActionMessage, summary)
          }
        });
        alertInstance.replaceState({
          ...(0, _common2.updateState)(ruleState, foundCerts),
          ...summary
        });
        alertInstance.scheduleActions(_synthetics_alerts.TLS_CERTIFICATE.id, {
          [_action_variables2.ALERT_DETAILS_URL]: await (0, _common.getAlertUrl)(alertUuid, spaceId, indexedStartedAt, alertsLocator, basePath.publicBaseUrl),
          ...summary
        });
      });
      await (0, _message_utils.setTLSRecoveredAlertsContext)({
        alertFactory,
        basePath,
        defaultStartedAt: startedAt.toISOString(),
        getAlertStartedDate,
        getAlertUuid,
        spaceId,
        alertsLocator,
        latestPings
      });
      return {
        state: (0, _common2.updateState)(ruleState, foundCerts)
      };
    },
    alerts: _common3.UptimeRuleTypeAlertDefinition
  });
};
exports.registerSyntheticsTLSCheckRule = registerSyntheticsTLSCheckRule;