"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UptimePlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/observability-plugin/public");
var _coreApplicationBrowser = require("@kbn/core-application-browser");
var _plugin = require("../common/constants/plugin");
var _ui = require("../common/constants/ui");
var _fleet_package = require("./legacy_uptime/components/fleet_package");
var _lazy_synthetics_custom_assets_extension = require("./legacy_uptime/components/fleet_package/lazy_synthetics_custom_assets_extension");
var _alert_types = require("./legacy_uptime/lib/alert_types");
var _locators = require("./apps/locators");
var _kibana_services = require("./kibana_services");
var _alert_types2 = require("./apps/synthetics/lib/alert_types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class UptimePlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "uptimeAppUpdater", new _rxjs.BehaviorSubject(() => ({})));
    this.initContext = initContext;
  }
  setup(core, plugins) {
    if (plugins.home) {
      plugins.home.featureCatalogue.register({
        id: _plugin.PLUGIN.ID,
        title: _plugin.PLUGIN.TITLE,
        description: _plugin.PLUGIN.DESCRIPTION,
        icon: 'uptimeApp',
        path: '/app/uptime',
        showOnHomePage: false,
        category: 'data'
      });
    }
    const getUptimeDataHelper = async () => {
      const [coreStart] = await core.getStartServices();
      const {
        UptimeDataHelper
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./legacy_uptime/app/uptime_overview_fetcher')));
      return UptimeDataHelper(coreStart);
    };
    _locators.locators.forEach(locator => {
      plugins.share.url.locators.create(locator);
    });
    plugins.observability.dashboard.register({
      appName: 'uptime',
      hasData: async () => {
        const dataHelper = await getUptimeDataHelper();
        const status = await dataHelper.indexStatus();
        return {
          hasData: status.indexExists,
          indices: status.indices
        };
      },
      fetchData: async params => {
        const dataHelper = await getUptimeDataHelper();
        return await dataHelper.overviewData(params);
      }
    });
    plugins.exploratoryView.register({
      appName: 'uptime',
      hasData: async () => {
        const dataHelper = await getUptimeDataHelper();
        const status = await dataHelper.indexStatus();
        return {
          hasData: status.indexExists,
          indices: status.indices
        };
      },
      fetchData: async params => {
        const dataHelper = await getUptimeDataHelper();
        return await dataHelper.overviewData(params);
      }
    });
    registerSyntheticsRoutesWithNavigation(core, plugins);
    core.getStartServices().then(([coreStart, clientPluginsStart]) => {});
    const appKeywords = ['Synthetics', 'availability', 'browser', 'checks', 'digital', 'reachability', 'reachable', 'response duration', 'response time', 'monitors', 'outside in', 'performance', 'pings', 'web performance', 'web perf'];
    core.application.register({
      id: _plugin.PLUGIN.ID,
      euiIconType: 'logoObservability',
      order: 8400,
      title: _plugin.PLUGIN.TITLE,
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      keywords: appKeywords,
      deepLinks: [{
        id: 'Down monitors',
        title: 'Down monitors',
        path: '/?statusFilter=down'
      }, {
        id: 'Certificates',
        title: 'TLS Certificates',
        path: '/certificates'
      }, {
        id: 'Settings',
        title: 'Settings',
        path: '/settings'
      }],
      mount: async params => {
        const [coreStart, corePlugins] = await core.getStartServices();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./legacy_uptime/app/render_app')));
        return renderApp(coreStart, plugins, corePlugins, params, this.initContext.env.mode.dev);
      },
      updater$: this.uptimeAppUpdater
    });

    // Register the Synthetics UI plugin
    core.application.register({
      id: 'synthetics',
      euiIconType: 'logoObservability',
      order: 8400,
      title: _plugin.PLUGIN.SYNTHETICS,
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      keywords: appKeywords,
      deepLinks: [],
      mount: async params => {
        const [coreStart, corePlugins] = await core.getStartServices();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./apps/synthetics/render_app')));
        return renderApp(coreStart, plugins, corePlugins, params, this.initContext.env.mode.dev);
      }
    });
  }
  start(coreStart, pluginsStart) {
    const {
      triggersActionsUi
    } = pluginsStart;
    const {
      registerExtension
    } = pluginsStart.fleet;
    (0, _kibana_services.setStartServices)(coreStart);
    registerUptimeFleetExtensions(registerExtension);
    _alert_types2.syntheticsAlertTypeInitializers.forEach(init => {
      const {
        observabilityRuleTypeRegistry
      } = pluginsStart.observability;
      const alertInitializer = init({
        core: coreStart,
        plugins: pluginsStart
      });
      if (!triggersActionsUi.ruleTypeRegistry.has(alertInitializer.id)) {
        observabilityRuleTypeRegistry.register(alertInitializer);
      }
    });
    _alert_types.uptimeAlertTypeInitializers.forEach(init => {
      const {
        observabilityRuleTypeRegistry
      } = pluginsStart.observability;
      const alertInitializer = init({
        core: coreStart,
        plugins: pluginsStart
      });
      if (!triggersActionsUi.ruleTypeRegistry.has(alertInitializer.id)) {
        observabilityRuleTypeRegistry.register(alertInitializer);
      }
    });
    _alert_types.legacyAlertTypeInitializers.forEach(init => {
      const alertInitializer = init({
        core: coreStart,
        plugins: pluginsStart
      });
      if (!triggersActionsUi.ruleTypeRegistry.has(alertInitializer.id)) {
        triggersActionsUi.ruleTypeRegistry.register(alertInitializer);
      }
    });
    setUptimeAppStatus(coreStart, pluginsStart, this.uptimeAppUpdater);
  }
  stop() {}
}
exports.UptimePlugin = UptimePlugin;
function registerUptimeRoutesWithNavigation(coreStart, plugins) {
  async function getUptimeSections() {
    if (coreStart.application.capabilities.uptime.show) {
      return [{
        label: 'Uptime',
        sortKey: 500,
        entries: [{
          label: _i18n.i18n.translate('xpack.synthetics.overview.uptimeHeading', {
            defaultMessage: 'Uptime Monitors'
          }),
          app: 'uptime',
          path: '/',
          matchFullPath: true,
          ignoreTrailingSlash: true
        }, {
          label: _i18n.i18n.translate('xpack.synthetics.certificatesPage.heading', {
            defaultMessage: 'TLS Certificates'
          }),
          app: 'uptime',
          path: '/certificates',
          matchFullPath: true
        }]
      }];
    }
    return [];
  }
  plugins.observabilityShared.navigation.registerSections((0, _rxjs.from)(getUptimeSections()));
}
function registerSyntheticsRoutesWithNavigation(core, plugins) {
  plugins.observabilityShared.navigation.registerSections((0, _rxjs.from)(core.getStartServices()).pipe((0, _operators.map)(([coreStart]) => {
    if (coreStart.application.capabilities.uptime.show) {
      return [{
        label: 'Synthetics',
        sortKey: 499,
        entries: [{
          label: _i18n.i18n.translate('xpack.synthetics.overview.SyntheticsHeading', {
            defaultMessage: 'Monitors'
          }),
          app: 'synthetics',
          path: _ui.OVERVIEW_ROUTE,
          matchFullPath: true,
          ignoreTrailingSlash: true,
          isNewFeature: true
        }, {
          label: _i18n.i18n.translate('xpack.synthetics.certificatesPage.heading', {
            defaultMessage: 'TLS Certificates'
          }),
          app: 'synthetics',
          path: '/certificates',
          matchFullPath: true
        }]
      }];
    }
    return [];
  })));
}
function registerUptimeFleetExtensions(registerExtension) {
  registerExtension({
    package: 'synthetics',
    view: 'package-policy-create',
    Component: _fleet_package.LazySyntheticsPolicyCreateExtension
  });
  registerExtension({
    package: 'synthetics',
    view: 'package-policy-edit',
    useLatestPackageVersion: true,
    Component: _fleet_package.LazySyntheticsPolicyEditExtension
  });
  registerExtension({
    package: 'synthetics',
    view: 'package-detail-assets',
    Component: _lazy_synthetics_custom_assets_extension.LazySyntheticsCustomAssetsExtension
  });
}
function setUptimeAppStatus(coreStart, pluginsStart, updater) {
  Promise.resolve().then(() => _interopRequireWildcard(require('./legacy_uptime/app/uptime_overview_fetcher'))).then(({
    UptimeDataHelper
  }) => {
    const isEnabled = coreStart.uiSettings.get(_public2.enableLegacyUptimeApp);
    if (isEnabled) {
      registerUptimeRoutesWithNavigation(coreStart, pluginsStart);
      updater.next(() => ({
        status: _coreApplicationBrowser.AppStatus.accessible
      }));
    } else {
      const indexStatusPromise = UptimeDataHelper(coreStart).indexStatus('now-7d', 'now');
      indexStatusPromise.then(indexStatus => {
        if (indexStatus.indexExists) {
          registerUptimeRoutesWithNavigation(coreStart, pluginsStart);
          updater.next(() => ({
            status: _coreApplicationBrowser.AppStatus.accessible
          }));
        } else {
          updater.next(() => ({
            status: _coreApplicationBrowser.AppStatus.inaccessible
          }));
        }
      });
    }
  });
}