"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSupportedUrlParams = void 0;
var _parse_is_paused = require("../../../../apps/synthetics/utils/url_params/parse_is_paused");
var _parse_url_int = require("../../../../apps/synthetics/utils/url_params/parse_url_int");
var _constants = require("../../../../../common/constants");
var _parse_absolute_date = require("../../../../apps/synthetics/utils/url_params/parse_absolute_date");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  ABSOLUTE_DATE_RANGE_START,
  ABSOLUTE_DATE_RANGE_END,
  AUTOREFRESH_INTERVAL,
  AUTOREFRESH_IS_PAUSED,
  DATE_RANGE_START,
  DATE_RANGE_END,
  SEARCH,
  FILTERS,
  STATUS_FILTER
} = _constants.CLIENT_DEFAULTS;

/**
 * Gets the current URL values for the application. If no item is present
 * for the URL, a default value is supplied.
 *
 * @param params A set of key-value pairs where the value is either
 * undefined or a string/string array. If a string array is passed,
 * only the first item is chosen. Support for lists in the URL will
 * require further development.
 */
const getSupportedUrlParams = params => {
  const filteredParams = {};
  Object.keys(params).forEach(key => {
    let value;
    if (params[key] === undefined) {
      value = undefined;
    } else if (Array.isArray(params[key])) {
      // @ts-ignore this must be an array, and it's ok if the
      // 0th element is undefined
      value = params[key][0];
    } else {
      // @ts-ignore this will not be an array because the preceding
      // block tests for that
      value = params[key];
    }
    filteredParams[key] = value;
  });
  const {
    autorefreshInterval,
    autorefreshIsPaused,
    dateRangeStart,
    dateRangeEnd,
    filters,
    excludedFilters,
    search,
    statusFilter,
    pagination,
    focusConnectorField,
    query
  } = filteredParams;
  return {
    pagination,
    absoluteDateRangeStart: (0, _parse_absolute_date.parseAbsoluteDate)(dateRangeStart || DATE_RANGE_START, ABSOLUTE_DATE_RANGE_START),
    absoluteDateRangeEnd: (0, _parse_absolute_date.parseAbsoluteDate)(dateRangeEnd || DATE_RANGE_END, ABSOLUTE_DATE_RANGE_END, {
      roundUp: true
    }),
    autorefreshInterval: (0, _parse_url_int.parseUrlInt)(autorefreshInterval, AUTOREFRESH_INTERVAL),
    autorefreshIsPaused: (0, _parse_is_paused.parseIsPaused)(autorefreshIsPaused, AUTOREFRESH_IS_PAUSED),
    dateRangeStart: dateRangeStart || DATE_RANGE_START,
    dateRangeEnd: dateRangeEnd || DATE_RANGE_END,
    filters: filters || FILTERS,
    excludedFilters: excludedFilters || '',
    search: search || SEARCH,
    statusFilter: statusFilter || STATUS_FILTER,
    focusConnectorField: !!focusConnectorField,
    query: query || ''
  };
};
exports.getSupportedUrlParams = getSupportedUrlParams;