"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mockDataPlugin = mockDataPlugin;
exports.mockDate = mockDate;
exports.mockDispatch = mockDispatch;
exports.mockMoment = mockMoment;
exports.mockMomentTimezone = mockMomentTimezone;
exports.mockReactRouterDomHooks = mockReactRouterDomHooks;
exports.mockReduxHooks = mockReduxHooks;
var _moment = _interopRequireDefault(require("moment"));
var redux = _interopRequireWildcard(require("react-redux"));
var reactRouterDom = _interopRequireWildcard(require("react-router-dom"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line no-restricted-imports

function mockMoment() {
  // avoid timezone issues
  jest.spyOn(_moment.default.prototype, 'format').mockImplementation(function () {
    return `Sept 4, 2020  9:31:38 AM`;
  });

  // convert relative time to absolute time to avoid timing issues
  jest.spyOn(_moment.default.prototype, 'fromNow').mockImplementation(function () {
    return `15 minutes ago`;
  });

  // use static locale string to avoid issues
  jest.spyOn(_moment.default.prototype, 'toLocaleString').mockImplementation(function () {
    return `Thu May 09 2019 10:15:11 GMT-0400`;
  });
}
function mockMomentTimezone() {
  jest.mock('moment-timezone', () => {
    return function () {
      return {
        tz: {
          guess: () => 'America/New_York'
        }
      };
    };
  });
}
function mockDate() {
  // use static date string to avoid CI timing issues
  jest.spyOn(Date.prototype, 'toString').mockImplementation(function () {
    return `Tue, 01 Jan 2019 00:00:00 GMT`;
  });
}
function mockDataPlugin() {
  jest.mock('@kbn/data-plugin/public', () => {
    return function () {
      return {
        esKuery: {
          fromKueryExpression: () => 'an ast',
          toElasticsearchQuery: () => 'an es query'
        }
      };
    };
  });
}
function mockReduxHooks(response) {
  jest.spyOn(redux, 'useDispatch').mockReturnValue(jest.fn());
  jest.spyOn(redux, 'useSelector').mockReturnValue(response);
}
function mockDispatch() {
  jest.spyOn(redux, 'useDispatch').mockReturnValue(jest.fn());
}
function mockReactRouterDomHooks({
  useParamsResponse
}) {
  jest.spyOn(reactRouterDom, 'useParams').mockReturnValue(useParamsResponse);
}