"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initMonitorStatusAlertType = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _get_monitor_url = require("../../../../common/utils/get_monitor_url");
var _translations = require("../../../../common/rules/legacy_uptime/translations");
var _uptime_alerts = require("../../../../common/constants/uptime_alerts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const {
  defaultActionMessage,
  defaultRecoveryMessage,
  description
} = _translations.MonitorStatusTranslations;
const MonitorStatusAlert = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./lazy_wrapper/monitor_status'))));
let validateFunc;
const initMonitorStatusAlertType = ({
  core,
  plugins
}) => ({
  id: _uptime_alerts.CLIENT_ALERT_TYPES.MONITOR_STATUS,
  description,
  iconClass: 'uptimeApp',
  documentationUrl(docLinks) {
    return `${docLinks.links.observability.monitorStatus}`;
  },
  ruleParamsExpression: params => /*#__PURE__*/_react.default.createElement(MonitorStatusAlert, {
    core: core,
    plugins: plugins,
    params: params
  }),
  validate: ruleParams => {
    if (!validateFunc) {
      (async function loadValidate() {
        const {
          validateMonitorStatusParams
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./lazy_wrapper/validate_monitor_status')));
        validateFunc = validateMonitorStatusParams;
      })();
    }
    return validateFunc ? validateFunc(ruleParams) : {};
  },
  defaultActionMessage,
  defaultRecoveryMessage,
  requiresAppContext: false,
  format: ({
    fields
  }) => ({
    reason: fields[_ruleDataUtils.ALERT_REASON] || '',
    link: (0, _get_monitor_url.getMonitorRouteFromMonitorId)({
      monitorId: fields['monitor.id'],
      dateRangeEnd: fields[_ruleDataUtils.ALERT_STATUS] === _ruleDataUtils.ALERT_STATUS_ACTIVE ? 'now' : fields[_ruleDataUtils.ALERT_END],
      dateRangeStart: (0, _moment.default)(new Date(fields[_ruleDataUtils.ALERT_START])).subtract('5', 'm').toISOString(),
      filters: {
        'observer.geo.name': [fields['observer.geo.name'][0]]
      }
    })
  })
});
exports.initMonitorStatusAlertType = initMonitorStatusAlertType;