"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDuration = void 0;
var React = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _step_field_trend = require("./step_field_trend");
var _formatting = require("../../../lib/formatting");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepDuration = ({
  step,
  durationPopoverOpenIndex,
  setDurationPopoverOpenIndex,
  showStepDurationTrend = true,
  compactView = false
}) => {
  var _step$synthetics$step2, _step$synthetics$step3, _step$synthetics$step6;
  const stepDurationText = (0, React.useMemo)(() => {
    var _step$synthetics$step;
    return _i18n.i18n.translate('xpack.synthetics.synthetics.step.duration', {
      defaultMessage: '{value} seconds',
      values: {
        value: (0, _formatting.microToSec)((_step$synthetics$step = step.synthetics.step) === null || _step$synthetics$step === void 0 ? void 0 : _step$synthetics$step.duration.us, 1)
      }
    });
  }, [(_step$synthetics$step2 = step.synthetics.step) === null || _step$synthetics$step2 === void 0 ? void 0 : _step$synthetics$step2.duration.us]);
  const component = (0, React.useMemo)(() => /*#__PURE__*/React.createElement(_step_field_trend.StepFieldTrend, {
    step: step,
    field: 'synthetics.step.duration.us',
    title: STEP_DURATION_TREND
  }), [step]);
  if (((_step$synthetics$step3 = step.synthetics.step) === null || _step$synthetics$step3 === void 0 ? void 0 : _step$synthetics$step3.status) === 'skipped') {
    return /*#__PURE__*/React.createElement("span", null, "--");
  }
  if (!showStepDurationTrend) {
    return /*#__PURE__*/React.createElement(_eui.EuiText, null, stepDurationText);
  }
  const button = /*#__PURE__*/React.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsStepDurationButton",
    onMouseEnter: () => {
      var _step$synthetics$step4, _step$synthetics$step5;
      return setDurationPopoverOpenIndex((_step$synthetics$step4 = (_step$synthetics$step5 = step.synthetics.step) === null || _step$synthetics$step5 === void 0 ? void 0 : _step$synthetics$step5.index) !== null && _step$synthetics$step4 !== void 0 ? _step$synthetics$step4 : null);
    },
    iconType: compactView ? undefined : 'visArea'
  }, stepDurationText);
  return /*#__PURE__*/React.createElement(_eui.EuiPopover, {
    onClick: evt => evt.stopPropagation(),
    isOpen: durationPopoverOpenIndex === ((_step$synthetics$step6 = step.synthetics.step) === null || _step$synthetics$step6 === void 0 ? void 0 : _step$synthetics$step6.index),
    button: button,
    closePopover: () => setDurationPopoverOpenIndex(null),
    zIndex: 100,
    ownFocus: false
  }, component);
};
exports.StepDuration = StepDuration;
const STEP_DURATION_TREND = _i18n.i18n.translate('xpack.synthetics.synthetics.step.durationTrend', {
  defaultMessage: 'Step duration trend'
});