"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnableMonitorAlert = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _selectors = require("../../../../state/selectors");
var _alerts = require("../../../../state/alerts/alerts");
var _constants = require("../../../../../../common/constants");
var _define_connectors = require("./define_connectors");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnableMonitorAlert = ({
  monitorId,
  selectedMonitor
}) => {
  var _alerts$data, _hasAlert, _settings$defaultConn2;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const {
    settings
  } = (0, _reactRedux.useSelector)(_selectors.selectDynamicSettings);
  const isMonitorPage = (0, _reactRouterDom.useRouteMatch)(_constants.MONITOR_ROUTE);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    data: actionConnectors
  } = (0, _reactRedux.useSelector)(_alerts.connectorsSelector);
  const {
    data: alerts,
    loading: alertsLoading
  } = (0, _reactRedux.useSelector)(_alerts.alertsSelector);
  const {
    data: deletedAlertId
  } = (0, _reactRedux.useSelector)(_alerts.isAlertDeletedSelector);
  const {
    data: newAlert,
    error: newAlertError
  } = (0, _reactRedux.useSelector)(_alerts.newAlertSelector);
  const isNewAlert = newAlert === null || newAlert === void 0 ? void 0 : newAlert.params.search.includes(monitorId);
  let hasAlert = ((_alerts$data = alerts === null || alerts === void 0 ? void 0 : alerts.data) !== null && _alerts$data !== void 0 ? _alerts$data : []).find(alert => alert.params.search.includes(monitorId));
  if (isNewAlert) {
    // if it's newly created alert, we assign that quickly without waiting for find alert result
    hasAlert = newAlert;
  }
  if (deletedAlertId === ((_hasAlert = hasAlert) === null || _hasAlert === void 0 ? void 0 : _hasAlert.id)) {
    // if it just got deleted, we assign that quickly without waiting for find alert result
    hasAlert = undefined;
  }
  const defaultActions = (actionConnectors !== null && actionConnectors !== void 0 ? actionConnectors : []).filter(act => {
    var _settings$defaultConn;
    return settings === null || settings === void 0 ? void 0 : (_settings$defaultConn = settings.defaultConnectors) === null || _settings$defaultConn === void 0 ? void 0 : _settings$defaultConn.includes(act.id);
  });
  const enableAlert = () => {
    dispatch(_alerts.createAlertAction.get({
      defaultActions,
      monitorId,
      selectedMonitor,
      defaultEmail: settings === null || settings === void 0 ? void 0 : settings.defaultEmail
    }));
    setIsLoading(true);
  };
  const disableAlert = () => {
    if (hasAlert) {
      dispatch(_alerts.deleteAlertAction.get({
        alertId: hasAlert.id
      }));
      setIsLoading(true);
    }
  };
  (0, _react.useEffect)(() => {
    setIsLoading(false);
  }, [hasAlert, deletedAlertId, newAlertError]);
  const hasDefaultConnectors = ((_settings$defaultConn2 = settings === null || settings === void 0 ? void 0 : settings.defaultConnectors) !== null && _settings$defaultConn2 !== void 0 ? _settings$defaultConn2 : []).length > 0;
  const showSpinner = isLoading || alertsLoading && !alerts;
  const onAlertClick = () => {
    if (hasAlert) {
      disableAlert();
    } else {
      enableAlert();
    }
  };
  const btnLabel = hasAlert ? _translations.DISABLE_STATUS_ALERT : _translations.ENABLE_STATUS_ALERT;
  return hasDefaultConnectors || hasAlert ? /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-displayInlineBlock",
    style: {
      marginRight: 10
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: btnLabel
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: 'enableDisableAlertSwitch',
    compressed: !isMonitorPage,
    disabled: showSpinner,
    label: btnLabel,
    showLabel: !!isMonitorPage,
    "aria-label": btnLabel,
    onChange: onAlertClick,
    checked: !!hasAlert,
    "data-test-subj": hasAlert ? 'uptimeDisableSimpleDownAlert' + monitorId : 'uptimeEnableSimpleDownAlert' + monitorId
  }), ' ', showSpinner && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    className: "eui-alignMiddle"
  })))) : /*#__PURE__*/_react.default.createElement(_define_connectors.DefineAlertConnectors, {
    showPopover: !isMonitorPage,
    showHelpText: !!isMonitorPage,
    showLabel: !!isMonitorPage
  });
};
exports.EnableMonitorAlert = EnableMonitorAlert;