"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallChartFixedAxis = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _use_chart_theme = require("../../../../../hooks/use_chart_theme");
var _styles = require("./styles");
var _waterfall_markers = require("./waterfall_markers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WaterfallChartFixedAxis = ({
  tickFormat,
  domain,
  barStyleAccessor
}) => {
  const theme = (0, _use_chart_theme.useChartTheme)();
  return /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartFixedAxisContainer, null, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    className: "axis-only-chart",
    "data-test-subj": "axisOnlyChart"
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: _charts.TooltipType.None
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: false,
    rotation: 90,
    theme: theme
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "time",
    position: _charts.Position.Top,
    tickFormat: tickFormat,
    domain: domain,
    gridLine: {
      visible: true
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    "aria-hidden": true,
    id: "waterfallItems",
    xScaleType: _charts.ScaleType.Ordinal,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    y0Accessors: ['y0'],
    styleAccessor: barStyleAccessor,
    data: [{
      x: 0,
      y0: 0,
      y1: 1
    }]
  }), /*#__PURE__*/_react.default.createElement(_waterfall_markers.WaterfallChartMarkers, null)));
};
exports.WaterfallChartFixedAxis = WaterfallChartFixedAxis;