"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorPageTitleContent = exports.MonitorPageTitle = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _hooks = require("../../hooks");
var _selectors = require("../../state/selectors");
var _enable_alert = require("../overview/monitor_list/columns/enable_alert");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isAutogeneratedId = id => {
  const autoGeneratedId = /^auto-(icmp|http|tcp|browser)-0X[A-F0-9]{16}.*/;
  return autoGeneratedId.test(id);
};

// For monitors with no explicit ID, we display the URL instead of the
// auto-generated ID because it is difficult to derive meaning from a
// generated id like `auto-http-0X8D6082B94BBE3B8A`.
// We may deprecate this behavior in the next major release, because
// the heartbeat config will require an explicit ID.
const getPageTitle = (monitorId, selectedMonitor) => {
  if (isAutogeneratedId(monitorId)) {
    var _selectedMonitor$url;
    return (selectedMonitor === null || selectedMonitor === void 0 ? void 0 : (_selectedMonitor$url = selectedMonitor.url) === null || _selectedMonitor$url === void 0 ? void 0 : _selectedMonitor$url.full) || monitorId;
  }
  return monitorId;
};
const MonitorPageTitleContent = () => {
  var _selectedMonitor$moni;
  const monitorId = (0, _hooks.useMonitorId)();
  const selectedMonitor = (0, _reactRedux.useSelector)(_selectors.monitorStatusSelector);
  const type = selectedMonitor === null || selectedMonitor === void 0 ? void 0 : (_selectedMonitor$moni = selectedMonitor.monitor) === null || _selectedMonitor$moni === void 0 ? void 0 : _selectedMonitor$moni.type;
  const isBrowser = type === 'browser';
  const renderMonitorType = monitorType => {
    switch (monitorType) {
      case 'http':
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.synthetics.monitorDetails.title.pingType.http",
          defaultMessage: "HTTP ping"
        });
      case 'tcp':
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.synthetics.monitorDetails.title.pingType.tcp",
          defaultMessage: "TCP ping"
        });
      case 'icmp':
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.synthetics.monitorDetails.title.pingType.icmp",
          defaultMessage: "ICMP ping"
        });
      case 'browser':
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.synthetics.monitorDetails.title.pingType.browser",
          defaultMessage: "Browser"
        });
      default:
        return '';
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: false,
    "data-test-subj": "monitorTitle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      justifyContent: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_enable_alert.EnableMonitorAlert, {
    monitorId: monitorId,
    selectedMonitor: selectedMonitor
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: false,
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isBrowser && type && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, renderMonitorType(type), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.monitorDetails.title.disclaimer.description",
    defaultMessage: "(BETA)"
  }))), isBrowser && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsMonitorPageTitleContentSeeMoreLink",
    href: "https://www.elastic.co/what-is/synthetic-monitoring",
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.monitorDetails.title.disclaimer.link",
    defaultMessage: "See more"
  }))))));
};
exports.MonitorPageTitleContent = MonitorPageTitleContent;
const MonitorPageTitle = () => {
  var _selectedMonitor$moni2;
  const monitorId = (0, _hooks.useMonitorId)();
  const selectedMonitor = (0, _reactRedux.useSelector)(_selectors.monitorStatusSelector);
  const nameOrId = (selectedMonitor === null || selectedMonitor === void 0 ? void 0 : (_selectedMonitor$moni2 = selectedMonitor.monitor) === null || _selectedMonitor$moni2 === void 0 ? void 0 : _selectedMonitor$moni2.name) || getPageTitle(monitorId, selectedMonitor);
  (0, _use_breadcrumbs.useBreadcrumbs)([{
    text: nameOrId
  }]);
  return /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textNoWrap"
  }, nameOrId);
};
exports.MonitorPageTitle = MonitorPageTitle;