"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MachineLearningFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _selectors = require("../../../state/selectors");
var _actions = require("../../../state/actions");
var _ml_job_link = require("./ml_job_link");
var labels = _interopRequireWildcard(require("./translations"));
var _ml_flyout = require("./ml_flyout");
var _contexts = require("../../../contexts");
var _hooks = require("../../../hooks");
var _dynamic_settings = require("../../../state/actions/dynamic_settings");
var _kibana_service = require("../../../state/kibana_service");
var _uptime_alerts = require("../../../../../common/constants/uptime_alerts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const showMLJobNotification = (monitorId, basePath, range, success, awaitingNodeAssignment, theme$, error) => {
  if (success) {
    _kibana_service.kibanaService.toasts.addSuccess({
      title: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement("p", {
        "data-test-subj": "uptimeMLJobSuccessfullyCreated"
      }, labels.JOB_CREATED_SUCCESS_TITLE), {
        theme$
      }),
      text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement("p", null, awaitingNodeAssignment ? labels.JOB_CREATED_LAZY_SUCCESS_MESSAGE : labels.JOB_CREATED_SUCCESS_MESSAGE, /*#__PURE__*/_react.default.createElement(_ml_job_link.MLJobLink, {
        monitorId: monitorId,
        basePath: basePath,
        dateRange: range
      }, labels.VIEW_JOB)), {
        theme$
      })
    }, {
      toastLifeTimeMs: 10000
    });
  } else {
    _kibana_service.kibanaService.toasts.addError(error, {
      title: labels.JOB_CREATION_FAILED,
      toastMessage: labels.JOB_CREATION_FAILED_MESSAGE,
      toastLifeTimeMs: 10000
    });
  }
};
const MachineLearningFlyout = ({
  onClose
}) => {
  const core = (0, _public.useKibana)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    data: hasMLJob,
    error
  } = (0, _reactRedux.useSelector)(_selectors.hasNewMLJobSelector);
  const isMLJobCreating = (0, _reactRedux.useSelector)(_selectors.isMLJobCreatingSelector);
  const {
    settings
  } = (0, _reactRedux.useSelector)(_selectors.selectDynamicSettings);
  (0, _react.useEffect)(() => {
    // Attempt to load or refresh the dynamic settings
    dispatch((0, _dynamic_settings.getDynamicSettings)({}));
  }, [dispatch]);
  const heartbeatIndices = (settings === null || settings === void 0 ? void 0 : settings.heartbeatIndices) || '';
  const {
    basePath
  } = (0, _react.useContext)(_contexts.UptimeSettingsContext);
  const {
    refreshApp
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  const monitorId = (0, _hooks.useMonitorId)();
  const canCreateMLJob = (0, _reactRedux.useSelector)(_selectors.canCreateMLJobSelector) && heartbeatIndices !== '';

  // This function is a noop in the form's disabled state
  const createMLJob = heartbeatIndices ? () => dispatch(_actions.createMLJobAction.get({
    monitorId: monitorId,
    heartbeatIndices
  })) : () => null;
  const {
    data: uptimeJobs
  } = (0, _reactRedux.useSelector)(_selectors.hasMLJobSelector);
  const hasExistingMLJob = !!(uptimeJobs !== null && uptimeJobs !== void 0 && uptimeJobs.jobsExist);
  const [isCreatingJob, setIsCreatingJob] = (0, _react.useState)(false);
  const {
    dateRangeStart,
    dateRangeEnd
  } = (0, _hooks.useGetUrlParams)();
  (0, _react.useEffect)(() => {
    if (isCreatingJob && !isMLJobCreating) {
      if (hasMLJob) {
        var _core$services$theme, _core$services$applic, _core$services$applic2, _core$services$applic3;
        showMLJobNotification(monitorId, basePath, {
          to: dateRangeEnd,
          from: dateRangeStart
        }, true, hasMLJob.awaitingNodeAssignment, (_core$services$theme = core.services.theme) === null || _core$services$theme === void 0 ? void 0 : _core$services$theme.theme$);
        dispatch(_actions.getExistingMLJobAction.get({
          monitorId: monitorId
        }));
        refreshApp();
        const hasUptimeWrite = (_core$services$applic = (_core$services$applic2 = core.services.application) === null || _core$services$applic2 === void 0 ? void 0 : (_core$services$applic3 = _core$services$applic2.capabilities.uptime) === null || _core$services$applic3 === void 0 ? void 0 : _core$services$applic3.save) !== null && _core$services$applic !== void 0 ? _core$services$applic : false;
        if (hasUptimeWrite) {
          dispatch((0, _actions.setAlertFlyoutType)(_uptime_alerts.CLIENT_ALERT_TYPES.DURATION_ANOMALY));
          dispatch((0, _actions.setAlertFlyoutVisible)(true));
        }
      } else {
        var _core$services$theme2;
        showMLJobNotification(monitorId, basePath, {
          to: dateRangeEnd,
          from: dateRangeStart
        }, false, false, (_core$services$theme2 = core.services.theme) === null || _core$services$theme2 === void 0 ? void 0 : _core$services$theme2.theme$, error);
      }
      setIsCreatingJob(false);
      onClose();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [hasMLJob, onClose, isCreatingJob, error, isMLJobCreating, monitorId, dispatch, basePath]);
  (0, _react.useEffect)(() => {
    if (hasExistingMLJob && !isMLJobCreating && !hasMLJob && heartbeatIndices) {
      setIsCreatingJob(true);
      dispatch(_actions.createMLJobAction.get({
        monitorId: monitorId,
        heartbeatIndices
      }));
    }

    // Don't add isMLJobCreating, because it will result int end less loop
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [dispatch, hasExistingMLJob, heartbeatIndices, monitorId, hasMLJob]);
  if (hasExistingMLJob) {
    return null;
  }
  const createAnomalyJob = () => {
    setIsCreatingJob(true);
    createMLJob();
  };
  return /*#__PURE__*/_react.default.createElement(_ml_flyout.MLFlyoutView, {
    canCreateMLJob: !!canCreateMLJob,
    isCreatingJob: isMLJobCreating,
    onClickCreate: createAnomalyJob,
    onClose: onClose
  });
};
exports.MachineLearningFlyout = MachineLearningFlyout;