"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GreenCheckIcon = exports.DonutChart = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _charts = require("@elastic/charts");
var _donut_chart_legend = require("./donut_chart_legend");
var _contexts = require("../../../contexts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GreenCheckIcon = (0, _styledComponents.default)(_eui.EuiIcon)`
  height: 42px;
  width: 42px;
  color: #017d73;
  top: 51px;
  left: 51px;
  position: absolute;
`;
exports.GreenCheckIcon = GreenCheckIcon;
const themeOverrides = {
  chartMargins: {
    top: 0,
    bottom: 0,
    left: 0,
    right: 0
  },
  partition: {
    linkLabel: {
      maximumSection: Infinity
    },
    idealFontSizeJump: 1.1,
    outerSizeRatio: 0.9,
    emptySizeRatio: 0.4,
    circlePadding: 4
  }
};
const DonutChart = ({
  height,
  down,
  up
}) => {
  var _chartTheme$theme;
  const {
    colors: {
      danger,
      gray
    },
    chartTheme
  } = (0, _react.useContext)(_contexts.UptimeThemeContext);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      position: 'relative'
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: height,
    "aria-label": _i18n.i18n.translate('xpack.synthetics.snapshot.donutChart.ariaLabel', {
      defaultMessage: 'Pie chart showing the current status. {down} of {total} monitors are down.',
      values: {
        down,
        total: up + down
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: [themeOverrides, (_chartTheme$theme = chartTheme.theme) !== null && _chartTheme$theme !== void 0 ? _chartTheme$theme : {}],
    baseTheme: chartTheme.baseTheme
  }), /*#__PURE__*/_react.default.createElement(_charts.Partition, {
    id: "spec_1",
    data: [{
      value: down,
      label: 'Down'
    }, {
      value: up,
      label: 'Up'
    }],
    layout: _charts.PartitionLayout.sunburst,
    valueAccessor: d => d.value,
    layers: [{
      groupByRollup: d => d.label,
      nodeLabel: d => d,
      shape: {
        fillColor: dataName => {
          return dataName === 'Down' ? danger : gray;
        }
      }
    }]
  })), down === 0 && /*#__PURE__*/_react.default.createElement(GreenCheckIcon, {
    className: "greenCheckIcon",
    type: "checkInCircleFilled"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_donut_chart_legend.DonutChartLegend, {
    down: down,
    up: up
  })));
};
exports.DonutChart = DonutChart;