"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchMonitorOverviewEffect = fetchMonitorOverviewEffect;
var _effects = require("redux-saga/effects");
var _fetch_effect = require("../utils/fetch_effect");
var _actions = require("./actions");
var _api = require("./api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function* fetchMonitorOverviewEffect() {
  yield (0, _effects.debounce)(200,
  // Only take the latest while ignoring any intermediate triggers
  [_actions.fetchMonitorOverviewAction.get, _actions.quietFetchOverviewAction.get], (0, _fetch_effect.fetchEffectFactory)(_api.fetchMonitorOverview, _actions.fetchMonitorOverviewAction.success, _actions.fetchMonitorOverviewAction.fail));
}