"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeEsQueryAPI = void 0;
var _common = require("@kbn/data-plugin/common");
var _public = require("@kbn/observability-shared-plugin/public");
var _common2 = require("@kbn/observability-shared-plugin/common");
var _kibana_service = require("../../../../utils/kibana_service");
var _api_service = require("../../../../utils/api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const executeEsQueryAPI = async ({
  params,
  name
}) => {
  const data = _kibana_service.kibanaService.startPlugins.data;
  const addInspectorRequest = _api_service.apiService.addInspectorRequest;
  const response = new Promise((resolve, reject) => {
    const startTime = Date.now();
    const search$ = data.search.search({
      params
    }, {}).subscribe({
      next: result => {
        if ((0, _common.isCompleteResponse)(result)) {
          if (addInspectorRequest) {
            addInspectorRequest({
              data: {
                _inspect: [(0, _common2.getInspectResponse)({
                  startTime,
                  esRequestParams: params,
                  esResponse: result.rawResponse,
                  esError: null,
                  esRequestStatus: 1,
                  operationName: name,
                  kibanaRequest: {
                    route: {
                      path: '/internal/bsearch',
                      method: 'POST'
                    }
                  }
                })]
              },
              status: _public.FETCH_STATUS.SUCCESS
            });
          }
          // Final result
          resolve(result);
          search$.unsubscribe();
        }
      },
      error: err => {
        if ((0, _common.isErrorResponse)(err)) {
          // eslint-disable-next-line no-console
          console.error(err);
          reject(err);
          if (addInspectorRequest) {
            addInspectorRequest({
              data: {
                _inspect: [(0, _common2.getInspectResponse)({
                  startTime,
                  esRequestParams: params,
                  esResponse: null,
                  esError: {
                    originalError: err,
                    name: err.name,
                    message: err.message
                  },
                  esRequestStatus: 2,
                  operationName: name,
                  kibanaRequest: {
                    route: {
                      path: '/internal/bsearch',
                      method: 'POST'
                    }
                  }
                })]
              },
              status: _public.FETCH_STATUS.SUCCESS
            });
          }
        }
      }
    });
  });
  const {
    rawResponse
  } = await response;
  return {
    result: rawResponse,
    name
  };
};
exports.executeEsQueryAPI = executeEsQueryAPI;