"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStatusByLocation = useStatusByLocation;
var _public = require("@kbn/observability-shared-plugin/public");
var _react = require("react");
var _use_locations = require("./use_locations");
var _client_defaults = require("../../../../common/constants/client_defaults");
var _constants = require("../../../../common/constants");
var _contexts = require("../contexts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useStatusByLocation({
  configId,
  monitorLocations
}) {
  var _data$aggregations2;
  const theme = (0, _public.useTheme)();
  const {
    lastRefresh
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const {
    locations: allLocations
  } = (0, _use_locations.useLocations)();
  const {
    data,
    loading
  } = (0, _public.useEsSearch)({
    index: _constants.SYNTHETICS_INDEX_PATTERN,
    body: {
      size: 0,
      query: {
        bool: {
          filter: [_client_defaults.SUMMARY_FILTER, _client_defaults.EXCLUDE_RUN_ONCE_FILTER, {
            term: {
              config_id: configId
            }
          }]
        }
      },
      sort: [{
        '@timestamp': 'desc'
      }],
      aggs: {
        locations: {
          terms: {
            field: 'observer.geo.name',
            missing: _constants.UNNAMED_LOCATION,
            size: 1000
          },
          aggs: {
            summary: {
              top_hits: {
                size: 1
              }
            }
          }
        }
      }
    }
  }, [lastRefresh, configId], {
    name: 'getMonitorStatusByLocation'
  });
  return (0, _react.useMemo)(() => {
    var _data$aggregations$lo, _data$aggregations;
    const getColor = status => {
      switch (status) {
        case 'up':
          return theme.eui.euiColorVis0;
        case 'down':
          return theme.eui.euiColorVis9;
        default:
          return 'subdued';
      }
    };
    const locationPings = ((_data$aggregations$lo = data === null || data === void 0 ? void 0 : (_data$aggregations = data.aggregations) === null || _data$aggregations === void 0 ? void 0 : _data$aggregations.locations.buckets) !== null && _data$aggregations$lo !== void 0 ? _data$aggregations$lo : []).map(loc => {
      var _loc$summary$hits$hit;
      return (_loc$summary$hits$hit = loc.summary.hits.hits) === null || _loc$summary$hits$hit === void 0 ? void 0 : _loc$summary$hits$hit[0]._source;
    });
    const locations = (monitorLocations !== null && monitorLocations !== void 0 ? monitorLocations : []).map(loc => {
      const fullLoc = allLocations.find(l => l.id === loc.id);
      if (fullLoc) {
        var _ping$summary$down, _ping$summary;
        const ping = locationPings.find(p => {
          var _p$observer, _p$observer$geo;
          return ((_p$observer = p.observer) === null || _p$observer === void 0 ? void 0 : (_p$observer$geo = _p$observer.geo) === null || _p$observer$geo === void 0 ? void 0 : _p$observer$geo.name) === (fullLoc === null || fullLoc === void 0 ? void 0 : fullLoc.label);
        });
        const status = ping ? ((_ping$summary$down = (_ping$summary = ping.summary) === null || _ping$summary === void 0 ? void 0 : _ping$summary.down) !== null && _ping$summary$down !== void 0 ? _ping$summary$down : 0 > 0) ? 'down' : 'up' : 'unknown';
        return {
          status,
          id: fullLoc === null || fullLoc === void 0 ? void 0 : fullLoc.id,
          label: fullLoc === null || fullLoc === void 0 ? void 0 : fullLoc.label,
          color: getColor(status)
        };
      }
    }).filter(Boolean);
    return {
      locations,
      loading
    };
  }, [allLocations, data === null || data === void 0 ? void 0 : (_data$aggregations2 = data.aggregations) === null || _data$aggregations2 === void 0 ? void 0 : _data$aggregations2.locations.buckets, loading, monitorLocations, theme.eui.euiColorVis0, theme.eui.euiColorVis9]);
}