"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorDetailLocator = useMonitorDetailLocator;
var _react = require("react");
var _common = require("@kbn/observability-plugin/common");
var _contexts = require("../contexts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useMonitorDetailLocator({
  configId,
  locationId
}) {
  var _useSyntheticsStartPl, _useSyntheticsStartPl2;
  const [monitorUrl, setMonitorUrl] = (0, _react.useState)(undefined);
  const locator = (_useSyntheticsStartPl = (0, _contexts.useSyntheticsStartPlugins)()) === null || _useSyntheticsStartPl === void 0 ? void 0 : (_useSyntheticsStartPl2 = _useSyntheticsStartPl.share) === null || _useSyntheticsStartPl2 === void 0 ? void 0 : _useSyntheticsStartPl2.url.locators.get(_common.syntheticsMonitorDetailLocatorID);
  (0, _react.useEffect)(() => {
    async function generateUrl() {
      const url = await (locator === null || locator === void 0 ? void 0 : locator.getUrl({
        configId,
        locationId
      }));
      setMonitorUrl(url);
    }
    generateUrl();
  }, [locator, configId, locationId]);
  return monitorUrl;
}