"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestNowModeFlyoutContainer = TestNowModeFlyoutContainer;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _use_test_flyout_open = require("./hooks/use_test_flyout_open");
var _test_now_mode_flyout = require("./test_now_mode_flyout");
var _manual_test_run_mode = require("./manual_test_run_mode/manual_test_run_mode");
var _contexts = require("../../contexts");
var _manual_test_runs = require("../../state/manual_test_runs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TestNowModeFlyoutContainer() {
  var _flyoutOpenTestRun$er;
  const dispatch = (0, _reactRedux.useDispatch)();
  const testNowRuns = (0, _reactRedux.useSelector)(_manual_test_runs.testNowRunsSelector);
  const {
    refreshApp
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const flyoutOpenTestRun = (0, _use_test_flyout_open.useTestFlyoutOpen)();
  const onDone = (0, _react.useCallback)(testRunId => {
    dispatch((0, _manual_test_runs.manualTestRunUpdateAction)({
      testRunId,
      status: _manual_test_runs.TestRunStatus.COMPLETED
    }));
    refreshApp();
  }, [dispatch, refreshApp]);
  const handleFlyoutClose = (0, _react.useCallback)(testRunId => {
    dispatch((0, _manual_test_runs.manualTestRunUpdateAction)({
      testRunId,
      isTestNowFlyoutOpen: false
    }));
  }, [dispatch]);
  const flyout = flyoutOpenTestRun ? /*#__PURE__*/_react.default.createElement(_test_now_mode_flyout.TestNowModeFlyout, {
    testRun: flyoutOpenTestRun !== null && flyoutOpenTestRun !== void 0 && flyoutOpenTestRun.testRunId && flyoutOpenTestRun !== null && flyoutOpenTestRun !== void 0 && flyoutOpenTestRun.monitor ? {
      id: flyoutOpenTestRun.testRunId,
      monitor: flyoutOpenTestRun.monitor,
      name: flyoutOpenTestRun.name
    } : undefined,
    name: flyoutOpenTestRun.name,
    inProgress: flyoutOpenTestRun.status === 'in-progress' || flyoutOpenTestRun.status === 'loading',
    onClose: () => handleFlyoutClose(flyoutOpenTestRun.testRunId),
    onDone: onDone,
    isPushing: flyoutOpenTestRun.status === 'loading',
    errors: (_flyoutOpenTestRun$er = flyoutOpenTestRun.errors) !== null && _flyoutOpenTestRun$er !== void 0 ? _flyoutOpenTestRun$er : []
  }) : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Object.values(testNowRuns).filter(val => val.testRunId && (val.status === 'in-progress' || val.status === 'loading')).map(manualTestRun => /*#__PURE__*/_react.default.createElement(_manual_test_run_mode.ManualTestRunMode, {
    key: manualTestRun.testRunId,
    manualTestRun: manualTestRun,
    onDone: onDone,
    showErrors: (flyoutOpenTestRun === null || flyoutOpenTestRun === void 0 ? void 0 : flyoutOpenTestRun.testRunId) !== manualTestRun.testRunId
  })), flyout);
}