"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManualTestRunMode = ManualTestRunMode;
var _react = _interopRequireWildcard(require("react"));
var _use_run_once_errors = require("../hooks/use_run_once_errors");
var _browser_test_results = require("./browser_test_results");
var _simple_test_results = require("./simple_test_results");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ManualTestRunMode({
  manualTestRun,
  onDone,
  showErrors
}) {
  var _locations, _manualTestRun$errors;
  const {
    expectPings
  } = (0, _use_run_once_errors.useRunOnceErrors)({
    showErrors,
    testRunId: manualTestRun.testRunId,
    locations: (_locations = manualTestRun.monitor.locations) !== null && _locations !== void 0 ? _locations : [],
    errors: (_manualTestRun$errors = manualTestRun.errors) !== null && _manualTestRun$errors !== void 0 ? _manualTestRun$errors : []
  });
  if (!manualTestRun.testRunId || !manualTestRun.monitor) return null;
  const isBrowserMonitor = manualTestRun.monitor.type === 'browser';
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: manualTestRun.testRunId
  }, isBrowserMonitor ? /*#__PURE__*/_react.default.createElement(_browser_test_results.BrowserTestRunResult, {
    name: manualTestRun.monitor.name,
    expectPings: expectPings,
    onDone: onDone,
    testRunId: manualTestRun.testRunId,
    onProgress: () => {}
  }) : /*#__PURE__*/_react.default.createElement(_simple_test_results.SimpleTestResults, {
    name: manualTestRun.monitor.name,
    expectPings: expectPings,
    onDone: onDone,
    testRunId: manualTestRun.testRunId
  }));
}