"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObjectWeightList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _color_palette = require("./color_palette");
var _use_object_metrics = require("../hooks/use_object_metrics");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ObjectWeightList = () => {
  const objectMetrics = (0, _use_object_metrics.useObjectMetrics)();
  const hasAnyThresholdBreach = objectMetrics.items.some(({
    weightDelta
  }) => Math.abs(Number(weightDelta)) > 5);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, OBJECT_WEIGHT_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, TOTAL_SIZE_LABEL, ":", ' ', /*#__PURE__*/_react.default.createElement("span", {
    style: {
      fontWeight: 'bold'
    }
  }, objectMetrics.totalObjectsWeight)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("div", null, objectMetrics.items.map(({
    label,
    mimeType,
    weightPercent,
    weight,
    weightDelta
  }) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: mimeType
  }, /*#__PURE__*/_react.default.createElement(_color_palette.ColorPalette, {
    hasAnyThresholdBreach: hasAnyThresholdBreach,
    label: label,
    mimeType: mimeType,
    percent: weightPercent,
    value: weight,
    loading: objectMetrics.loading,
    delta: Number(weightDelta)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), ' '))));
};
exports.ObjectWeightList = ObjectWeightList;
const OBJECT_WEIGHT_LABEL = _i18n.i18n.translate('xpack.synthetics.stepDetails.objectWeight', {
  defaultMessage: 'Object weight'
});
const TOTAL_SIZE_LABEL = _i18n.i18n.translate('xpack.synthetics.stepDetails.totalSize', {
  defaultMessage: 'Total size'
});