"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkTimingsBreakdown = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _public2 = require("@kbn/exploratory-view-plugin/public");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_selected_location = require("../monitor_details/hooks/use_selected_location");
var _monitor_detail_flyout = require("../monitors_page/overview/overview/monitor_detail_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NetworkTimingsBreakdown = ({
  monitorId
}) => {
  const {
    exploratoryView: {
      ExploratoryViewEmbeddable
    }
  } = (0, _public.useKibana)().services;
  const {
    stepIndex
  } = (0, _reactRouterDom.useParams)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  if (!selectedLocation) {
    return /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.LoadingState, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, LAST_24_HOURS)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    customHeight: "250px",
    reportType: _public2.ReportTypes.KPI,
    legendIsVisible: false,
    axisTitlesVisibility: {
      x: false,
      yLeft: false,
      yRight: false
    },
    attributes: [{
      operationType: 'last_value',
      seriesType: 'area_stacked',
      dataType: 'synthetics',
      name: 'Network timings',
      selectedMetricField: 'network_timings',
      reportDefinitions: {
        'monitor.id': [monitorId]
      },
      time: {
        from: 'now-24h/h',
        to: 'now'
      },
      filters: [{
        field: 'synthetics.step.index',
        values: [stepIndex]
      }, {
        field: 'observer.geo.name',
        values: [selectedLocation.label]
      }]
    }]
  }));
};
exports.NetworkTimingsBreakdown = NetworkTimingsBreakdown;
const LAST_24_HOURS = _i18n.i18n.translate('xpack.synthetics.stepDetailsRoute.last24Hours', {
  defaultMessage: 'Last 24 hours'
});