"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStepDetailPage = exports.useStepDetailLink = void 0;
var _reactRouterDom = require("react-router-dom");
var _react = require("react");
var _use_selected_location = require("../../monitor_details/hooks/use_selected_location");
var _contexts = require("../../../contexts");
var _use_journey_steps = require("../../monitor_details/hooks/use_journey_steps");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStepDetailPage = () => {
  const {
    checkGroupId,
    monitorId,
    stepIndex: stepIndexString
  } = (0, _reactRouterDom.useParams)();
  const stepIndex = Number(stepIndexString);
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const {
    data: journey,
    stepEnds
  } = (0, _use_journey_steps.useJourneySteps)(checkGroupId);
  const memoized = (0, _react.useMemo)(() => {
    var _journey$steps;
    return {
      activeStep: journey === null || journey === void 0 ? void 0 : (_journey$steps = journey.steps) === null || _journey$steps === void 0 ? void 0 : _journey$steps.find(step => {
        var _step$synthetics, _step$synthetics$step;
        return ((_step$synthetics = step.synthetics) === null || _step$synthetics === void 0 ? void 0 : (_step$synthetics$step = _step$synthetics.step) === null || _step$synthetics$step === void 0 ? void 0 : _step$synthetics$step.index) === stepIndex;
      })
    };
  }, [journey, stepIndex]);
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const handleStepHref = stepNo => getStepDetailLink({
    basePath,
    monitorId,
    checkGroupId,
    stepIndex: stepNo,
    locationId: selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id
  });
  return {
    checkGroupId,
    journey,
    stepIndex,
    stepEnds,
    ...memoized,
    handleStepHref
  };
};
exports.useStepDetailPage = useStepDetailPage;
const useStepDetailLink = ({
  checkGroupId,
  stepIndex
}) => {
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  if (!checkGroupId) {
    return '';
  }
  return getStepDetailLink({
    basePath,
    stepIndex,
    monitorId,
    checkGroupId,
    locationId: selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id
  });
};
exports.useStepDetailLink = useStepDetailLink;
const getStepDetailLink = ({
  checkGroupId,
  stepIndex,
  basePath,
  monitorId,
  locationId
}) => {
  return `${basePath}/app/synthetics/monitor/${monitorId}/test-run/${checkGroupId}/step/${stepIndex}?locationId=${locationId}`;
};