"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewLocationMonitors = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ViewLocationMonitors = ({
  count,
  locationName
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => setIsPopoverOpen(prevState => !prevState);
  const closePopover = () => setIsPopoverOpen(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsViewLocationMonitorsButton",
    onClick: onButtonClick
  }, count);
  const history = (0, _reactRouterDom.useHistory)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.monitorManagement.viewMonitors",
    defaultMessage: "{name} is used in {count, number} {count, plural,one {monitor} other {monitors}}.",
    values: {
      count,
      name: /*#__PURE__*/_react.default.createElement("strong", null, locationName)
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), count > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsViewLocationMonitorsButton",
    href: history.createHref({
      pathname: '/monitors',
      search: `?locations=${JSON.stringify([locationName])}`
    })
  }, VIEW_LOCATION_MONITORS) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsViewLocationMonitorsButton",
    href: history.createHref({
      pathname: '/add-monitor'
    })
  }, CREATE_MONITOR));
};
exports.ViewLocationMonitors = ViewLocationMonitors;
const VIEW_LOCATION_MONITORS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.viewLocationMonitors', {
  defaultMessage: 'View monitors'
});
const CREATE_MONITOR = _i18n.i18n.translate('xpack.synthetics.monitorManagement.createLocationMonitors', {
  defaultMessage: 'Create monitor'
});