"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagePrivateLocations = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _monitor_detail_flyout = require("../../monitors_page/overview/overview/monitor_detail_flyout");
var _locations_table = require("./locations_table");
var _manage_empty_state = require("./manage_empty_state");
var _add_location_flyout = require("./add_location_flyout");
var _use_locations_api = require("./hooks/use_locations_api");
var _private_locations = require("../../../state/private_locations");
var _state = require("../../../state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManagePrivateLocations = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const isAddingNew = (0, _reactRedux.useSelector)(_private_locations.selectAddingNewPrivateLocation);
  const setIsAddingNew = (0, _react.useCallback)(val => dispatch((0, _private_locations.setAddingNewPrivateLocation)(val)), [dispatch]);
  const {
    onSubmit,
    loading,
    privateLocations,
    onDelete,
    deleteLoading
  } = (0, _use_locations_api.usePrivateLocationsAPI)();

  // make sure flyout is closed when first visiting the page
  (0, _react.useEffect)(() => {
    setIsAddingNew(false);
  }, [setIsAddingNew]);
  (0, _react.useEffect)(() => {
    dispatch(_private_locations.getAgentPoliciesAction.get());
    dispatch((0, _state.getServiceLocations)());
  }, [dispatch]);
  const handleSubmit = formData => {
    onSubmit(formData);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, loading ? /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.LoadingState, null) : /*#__PURE__*/_react.default.createElement(_manage_empty_state.ManageEmptyState, {
    privateLocations: privateLocations,
    setIsAddingNew: setIsAddingNew
  }, /*#__PURE__*/_react.default.createElement(_locations_table.PrivateLocationsTable, {
    privateLocations: privateLocations,
    onDelete: onDelete,
    deleteLoading: deleteLoading
  })), isAddingNew ? /*#__PURE__*/_react.default.createElement(_add_location_flyout.AddLocationFlyout, {
    setIsOpen: setIsAddingNew,
    onSubmit: handleSubmit,
    privateLocations: privateLocations,
    isLoading: loading
  }) : null);
};
exports.ManagePrivateLocations = ManagePrivateLocations;