"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FailedTestsByStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _panel_with_title = require("../../common/components/panel_with_title");
var _use_selected_monitor = require("../hooks/use_selected_monitor");
var _use_failed_tests_by_step = require("../hooks/use_failed_tests_by_step");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FailedTestsByStep = ({
  time
}) => {
  const {
    failedSteps,
    loading
  } = (0, _use_failed_tests_by_step.useFailedTestByStep)(time);
  const {
    monitor
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  if ((monitor === null || monitor === void 0 ? void 0 : monitor.type) !== 'browser') {
    return null;
  }
  if (loading && !failedSteps) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 3
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_panel_with_title.PanelWithTitle, {
    title: FAILED_TESTS_BY_STEPS_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("div", null, failedSteps === null || failedSteps === void 0 ? void 0 : failedSteps.map(item => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: item.name
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    valueText: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.failedTests.count', {
      defaultMessage: 'Failed {count}',
      values: {
        count: item.count
      }
    })),
    max: 100,
    color: "danger",
    size: "l",
    value: item.percent,
    label: `${item.index}. ${item.name}`
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }))))));
};
exports.FailedTestsByStep = FailedTestsByStep;
const FAILED_TESTS_BY_STEPS_LABEL = _i18n.i18n.translate('xpack.synthetics.errors.failedTests.byStep', {
  defaultMessage: 'Failed tests by step'
});