"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _public = require("@kbn/observability-shared-plugin/public");
var _run_test_btn = require("./run_test_btn");
var _use_capabilities = require("../../../../../hooks/use_capabilities");
var _use_monitor_save = require("../hooks/use_monitor_save");
var _permissions = require("../../common/components/permissions");
var _delete_monitor = require("../../monitors_page/management/monitor_list_table/delete_monitor");
var _types = require("../types");
var _formatter = require("./formatter");
var _constants = require("../../../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionBar = ({
  readOnly = false
}) => {
  var _defaultValues$Config;
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    handleSubmit,
    formState: {
      errors,
      defaultValues
    },
    getValues,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const [monitorPendingDeletion, setMonitorPendingDeletion] = (0, _react.useState)(null);
  const [monitorData, setMonitorData] = (0, _react.useState)(undefined);
  const {
    status,
    loading,
    isEdit
  } = (0, _use_monitor_save.useMonitorSave)({
    monitorData
  });
  const canEditSynthetics = (0, _use_capabilities.useCanEditSynthetics)();
  const formSubmitter = formData => {
    // An additional invalid field check to account for customHook managed validation
    const isAnyFieldInvalid = Object.keys(getValues()).some(fieldKey => getFieldState(fieldKey).invalid);
    if (!Object.keys(errors).length && !isAnyFieldInvalid) {
      setMonitorData((0, _formatter.format)(formData, readOnly));
    }
  };
  return status === _public.FETCH_STATUS.SUCCESS ? /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: _constants.MONITORS_ROUTE
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, isEdit && defaultValues && /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsActionBarButton",
    color: "danger",
    onClick: () => {
      setMonitorPendingDeletion(defaultValues);
    }
  }, DELETE_MONITOR_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsActionBarLink",
    href: history.createHref({
      pathname: _constants.MONITORS_ROUTE
    })
  }, CANCEL_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_run_test_btn.RunTestButton, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      marginLeft: 'auto'
    }
  }, /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
    canEditSynthetics: canEditSynthetics
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isLoading: loading,
    onClick: handleSubmit(formSubmitter),
    "data-test-subj": "syntheticsMonitorConfigSubmitButton",
    disabled: !canEditSynthetics
  }, isEdit ? UPDATE_MONITOR_LABEL : CREATE_MONITOR_LABEL)))), monitorPendingDeletion && /*#__PURE__*/_react.default.createElement(_delete_monitor.DeleteMonitor, {
    configId: monitorId,
    name: (_defaultValues$Config = defaultValues === null || defaultValues === void 0 ? void 0 : defaultValues[_types.ConfigKey.NAME]) !== null && _defaultValues$Config !== void 0 ? _defaultValues$Config : '',
    reloadPage: () => {
      history.push(_constants.MONITORS_ROUTE);
    },
    setMonitorPendingDeletion: setMonitorPendingDeletion,
    isProjectMonitor: (defaultValues === null || defaultValues === void 0 ? void 0 : defaultValues[_types.ConfigKey.MONITOR_SOURCE_TYPE]) === _types.SourceType.PROJECT
  }));
};
exports.ActionBar = ActionBar;
const CANCEL_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.discardLabel', {
  defaultMessage: 'Cancel'
});
const CREATE_MONITOR_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.addEdit.createMonitorLabel', {
  defaultMessage: 'Create monitor'
});
const DELETE_MONITOR_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.addEdit.deleteMonitorLabel', {
  defaultMessage: 'Delete monitor'
});
const UPDATE_MONITOR_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.updateMonitorLabel', {
  defaultMessage: 'Update monitor'
});