"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorTypeRadioGroup = exports.MonitorType = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorType = ({
  id,
  value,
  label,
  icon,
  onChange,
  name,
  isSelected,
  'data-test-subj': dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiKeyPadMenuItem, {
    checkable: "single",
    label: label,
    id: id,
    value: value,
    onChange: onChange,
    name: name,
    isSelected: isSelected,
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon
  }));
};
exports.MonitorType = MonitorType;
const MonitorTypeRadioGroup = ({
  options,
  value,
  name,
  onChange,
  ariaLegend,
  ...props
}) => {
  const selectedOption = options.find(radio => radio.value === value);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiKeyPadMenu, {
    checkable: {
      ariaLegend
    },
    css: {
      width: '100%'
    }
  }, options.map(radio => {
    return /*#__PURE__*/_react.default.createElement(MonitorType, (0, _extends2.default)({}, props, radio, {
      name: name,
      onChange: onChange,
      isSelected: radio.value === value,
      "data-test-subj": radio['data-test-subj'],
      key: radio.value
    }));
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), selectedOption && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, selectedOption.descriptionTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("span", null, `${selectedOption.description} `), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsMonitorTypeRadioGroupLearnMoreLink",
    href: selectedOption.link,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.synthetics.monitorConfig.monitorType.learnMoreLink', {
    defaultMessage: 'Learn more'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  })));
};
exports.MonitorTypeRadioGroup = MonitorTypeRadioGroup;