"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimingDetails = exports.StepMetrics = exports.ResultDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_step_metrics = require("../../step_details_page/hooks/use_step_metrics");
var _journey_step_screenshot_container = require("../screenshot/journey_step_screenshot_container");
var _thershold_indicator = require("../components/thershold_indicator");
var _use_network_timings = require("../../step_details_page/hooks/use_network_timings");
var _use_network_timings_prev = require("../../step_details_page/hooks/use_network_timings_prev");
var _data_formatting = require("../../step_details_page/common/network_data/data_formatting");
var _status_badge = require("./status_badge");
var _use_step_prev_metrics = require("../../step_details_page/hooks/use_step_prev_metrics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResultDetails = ({
  testNowMode,
  pingStatus,
  isExpanded,
  step
}) => {
  var _step$synthetics$step, _step$synthetics, _step$synthetics$step2, _step$synthetics2, _step$synthetics2$ste, _step$synthetics$payl;
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-textNoWrap",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_status_badge.StatusBadge, {
    status: (0, _status_badge.parseBadgeStatus)(pingStatus)
  }), ' ', !testNowMode ? _i18n.i18n.translate('xpack.synthetics.step.duration.label', {
    defaultMessage: 'after {value}',
    values: {
      value: (0, _data_formatting.formatMillisecond)(((_step$synthetics$step = (_step$synthetics = step.synthetics) === null || _step$synthetics === void 0 ? void 0 : (_step$synthetics$step2 = _step$synthetics.step) === null || _step$synthetics$step2 === void 0 ? void 0 : _step$synthetics$step2.duration.us) !== null && _step$synthetics$step !== void 0 ? _step$synthetics$step : 0) / 1000, {})
    }
  }) : ''), isExpanded && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_journey_step_screenshot_container.JourneyStepScreenshotContainer, {
    checkGroup: step.monitor.check_group,
    initialStepNumber: (_step$synthetics2 = step.synthetics) === null || _step$synthetics2 === void 0 ? void 0 : (_step$synthetics2$ste = _step$synthetics2.step) === null || _step$synthetics2$ste === void 0 ? void 0 : _step$synthetics2$ste.index,
    stepStatus: (_step$synthetics$payl = step.synthetics.payload) === null || _step$synthetics$payl === void 0 ? void 0 : _step$synthetics$payl.status,
    allStepsLoaded: true,
    retryFetchOnRevisit: false,
    size: [260, 160]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(TimingDetails, {
    step: step
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(StepMetrics, {
    step: step
  })));
};
exports.ResultDetails = ResultDetails;
const TimingDetails = ({
  step
}) => {
  var _step$synthetics$step3, _step$synthetics$step4;
  const {
    timingsWithLabels
  } = (0, _use_network_timings.useNetworkTimings)(step.monitor.check_group, (_step$synthetics$step3 = step.synthetics.step) === null || _step$synthetics$step3 === void 0 ? void 0 : _step$synthetics$step3.index);
  const {
    timingsWithLabels: prevTimingsWithLabels,
    loading
  } = (0, _use_network_timings_prev.useNetworkTimingsPrevious24Hours)((_step$synthetics$step4 = step.synthetics.step) === null || _step$synthetics$step4 === void 0 ? void 0 : _step$synthetics$step4.index, step['@timestamp'], step.monitor.check_group);
  const items = timingsWithLabels === null || timingsWithLabels === void 0 ? void 0 : timingsWithLabels.map(item => {
    const prevValueItem = prevTimingsWithLabels === null || prevTimingsWithLabels === void 0 ? void 0 : prevTimingsWithLabels.find(prev => prev.label === item.label);
    const prevValue = prevValueItem === null || prevValueItem === void 0 ? void 0 : prevValueItem.value;
    return {
      title: item.label,
      description: /*#__PURE__*/_react.default.createElement(_thershold_indicator.ThresholdIndicator, {
        loading: loading,
        currentFormatted: (0, _data_formatting.formatMillisecond)(item.value, {}),
        current: item.value,
        previous: prevValue,
        previousFormatted: (0, _data_formatting.formatMillisecond)(prevValue !== null && prevValue !== void 0 ? prevValue : 0, {})
      })
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    gutterSize: "s",
    type: "column",
    listItems: items,
    style: {
      maxWidth: 265
    },
    textStyle: "reverse",
    descriptionProps: {
      style: {
        textAlign: 'right'
      }
    }
  });
};
exports.TimingDetails = TimingDetails;
const StepMetrics = ({
  step
}) => {
  const {
    metrics: stepMetrics
  } = (0, _use_step_metrics.useStepMetrics)(step);
  const {
    metrics: prevMetrics,
    loading
  } = (0, _use_step_prev_metrics.useStepPrevMetrics)(step);
  const items = stepMetrics === null || stepMetrics === void 0 ? void 0 : stepMetrics.map(item => {
    var _item$value;
    const prevValueItem = prevMetrics === null || prevMetrics === void 0 ? void 0 : prevMetrics.find(prev => prev.label === item.label);
    const prevValue = prevValueItem === null || prevValueItem === void 0 ? void 0 : prevValueItem.value;
    return {
      title: item.label,
      description: /*#__PURE__*/_react.default.createElement(_thershold_indicator.ThresholdIndicator, {
        loading: loading,
        currentFormatted: item.formatted,
        current: (_item$value = item.value) !== null && _item$value !== void 0 ? _item$value : 0,
        previous: prevValue,
        previousFormatted: prevValueItem === null || prevValueItem === void 0 ? void 0 : prevValueItem.formatted
      })
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    gutterSize: "s",
    type: "column",
    listItems: items,
    style: {
      maxWidth: 265
    },
    textStyle: "reverse",
    descriptionProps: {
      style: {
        textAlign: 'right'
      }
    }
  });
};
exports.StepMetrics = StepMetrics;