"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BrowserStepsList = void 0;
exports.isStepEnd = isStepEnd;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _step_tabs = require("../../test_run_details/step_tabs");
var _result_details = require("./result_details");
var _journey_step_screenshot_container = require("../screenshot/journey_step_screenshot_container");
var _screenshot_size = require("../screenshot/screenshot_size");
var _step_details_link = require("../links/step_details_link");
var _status_badge = require("./status_badge");
var _step_duration_text = require("./step_duration_text");
var _result_details_successful = require("./result_details_successful");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isStepEnd(step) {
  var _step$synthetics;
  return ((_step$synthetics = step.synthetics) === null || _step$synthetics === void 0 ? void 0 : _step$synthetics.type) === 'step/end';
}
const BrowserStepsList = ({
  steps,
  error,
  loading,
  screenshotImageSize = _screenshot_size.THUMBNAIL_SCREENSHOT_SIZE,
  showLastSuccessful = true,
  showStepNumber = false,
  compressed = true,
  showExpand = true,
  testNowMode = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const stepEnds = steps.filter(isStepEnd);
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  const isTabletOrGreater = (0, _eui.useIsWithinMinBreakpoint)('s');
  const toggleDetails = (0, _react.useCallback)(item => {
    setItemIdToExpandedRowMap(prevState => {
      const itemIdToExpandedRowMapValues = {
        ...prevState
      };
      if (itemIdToExpandedRowMapValues[item._id]) {
        delete itemIdToExpandedRowMapValues[item._id];
      } else {
        if (testNowMode) {
          itemIdToExpandedRowMapValues[item._id] = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_step_tabs.StepTabs, {
            step: item,
            loading: false,
            stepsList: steps
          })));
        } else {
          itemIdToExpandedRowMapValues[item._id] = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
        }
      }
      return itemIdToExpandedRowMapValues;
    });
  }, [steps, testNowMode]);
  const failedStep = stepEnds === null || stepEnds === void 0 ? void 0 : stepEnds.find(step => {
    var _step$synthetics$step;
    return ((_step$synthetics$step = step.synthetics.step) === null || _step$synthetics$step === void 0 ? void 0 : _step$synthetics$step.status) === 'failed';
  });
  (0, _react.useEffect)(() => {
    if (failedStep && showExpand) {
      toggleDetails(failedStep);
    }
  }, [failedStep, showExpand, toggleDetails]);
  const columns = [...(showExpand ? [{
    align: 'left',
    width: '40px',
    isExpander: true,
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: () => toggleDetails(item),
      "aria-label": itemIdToExpandedRowMap[item._id] ? 'Collapse' : 'Expand',
      iconType: itemIdToExpandedRowMap[item._id] ? 'arrowDown' : 'arrowRight'
    })
  }] : []), ...(showStepNumber ? [{
    field: 'synthetics.step.index',
    name: '#',
    render: (stepIndex, item) => /*#__PURE__*/_react.default.createElement(StyleForStepStatus, {
      step: item,
      euiTheme: euiTheme
    }, stepIndex),
    mobileOptions: {
      show: false
    }
  }] : []), {
    align: 'left',
    field: 'timestamp',
    name: SCREENSHOT_LABEL,
    render: (timestamp, step) => {
      var _step$synthetics2, _step$synthetics2$ste, _step$synthetics$payl;
      return /*#__PURE__*/_react.default.createElement(_journey_step_screenshot_container.JourneyStepScreenshotContainer, {
        checkGroup: step.monitor.check_group,
        initialStepNumber: (_step$synthetics2 = step.synthetics) === null || _step$synthetics2 === void 0 ? void 0 : (_step$synthetics2$ste = _step$synthetics2.step) === null || _step$synthetics2$ste === void 0 ? void 0 : _step$synthetics2$ste.index,
        stepStatus: (_step$synthetics$payl = step.synthetics.payload) === null || _step$synthetics$payl === void 0 ? void 0 : _step$synthetics$payl.status,
        allStepsLoaded: !loading,
        retryFetchOnRevisit: true,
        size: screenshotImageSize,
        testNowMode: testNowMode,
        timestamp: timestamp
      });
    },
    mobileOptions: {
      render: step => /*#__PURE__*/_react.default.createElement(MobileRowDetails, {
        journeyStep: step,
        stepsLoading: loading,
        showStepNumber: showStepNumber,
        showLastSuccessful: showLastSuccessful,
        isExpanded: Boolean(itemIdToExpandedRowMap[step._id]),
        isTestNowMode: testNowMode,
        euiTheme: euiTheme
      }),
      header: false,
      enlarge: true,
      width: '100%'
    }
  }, {
    field: 'synthetics.step.name',
    name: STEP_NAME,
    render: (stepName, item) => {
      var _item$synthetics$step, _item$synthetics$step2;
      const status = (0, _status_badge.parseBadgeStatus)((_item$synthetics$step = (_item$synthetics$step2 = item.synthetics.step) === null || _item$synthetics$step2 === void 0 ? void 0 : _item$synthetics$step2.status) !== null && _item$synthetics$step !== void 0 ? _item$synthetics$step : '');
      const textColor = euiTheme.colors[(0, _status_badge.getTextColorForMonitorStatus)(status)];
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: textColor,
        size: "m"
      }, stepName);
    },
    mobileOptions: {
      show: false
    }
  }, {
    field: 'synthetics.step.status',
    name: RESULT_LABEL,
    render: (pingStatus, item) => /*#__PURE__*/_react.default.createElement(_result_details.ResultDetails, {
      testNowMode: testNowMode,
      step: item,
      pingStatus: pingStatus,
      isExpanded: Boolean(itemIdToExpandedRowMap[item._id]) && !testNowMode
    }),
    mobileOptions: {
      show: false
    }
  }, ...(showLastSuccessful ? [{
    field: 'synthetics.step.status',
    name: LAST_SUCCESSFUL,
    render: (pingStatus, item) => /*#__PURE__*/_react.default.createElement(_result_details_successful.ResultDetailsSuccessful, {
      step: item,
      isExpanded: Boolean(itemIdToExpandedRowMap[item._id])
    }),
    mobileOptions: {
      show: false
    }
  }] : [{
    align: 'left',
    name: STEP_DURATION,
    render: item => {
      return /*#__PURE__*/_react.default.createElement(_step_duration_text.StepDurationText, {
        step: item
      });
    },
    mobileOptions: {
      header: STEP_DURATION,
      show: true
    }
  }]), {
    align: 'right',
    field: 'timestamp',
    name: '',
    render: (_val, item) => {
      var _item$synthetics, _item$synthetics$step3;
      return /*#__PURE__*/_react.default.createElement(_step_details_link.StepDetailsLinkIcon, {
        checkGroup: item.monitor.check_group,
        stepIndex: (_item$synthetics = item.synthetics) === null || _item$synthetics === void 0 ? void 0 : (_item$synthetics$step3 = _item$synthetics.step) === null || _item$synthetics$step3 === void 0 ? void 0 : _item$synthetics$step3.index,
        configId: item.config_id,
        target: testNowMode ? '_blank' : undefined
      });
    },
    mobileOptions: {
      show: false
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    css: {
      overflowX: isTabletOrGreater ? 'auto' : undefined
    },
    cellProps: row => {
      if (itemIdToExpandedRowMap[row._id]) {
        return {
          style: {
            verticalAlign: 'top'
          }
        };
      }
    },
    compressed: compressed,
    loading: loading,
    columns: columns,
    error: error === null || error === void 0 ? void 0 : error.message,
    isExpandable: showExpand,
    hasActions: false,
    items: stepEnds,
    noItemsMessage: loading ? _i18n.i18n.translate('xpack.synthetics.monitor.step.loading', {
      defaultMessage: 'Loading steps...'
    }) : _i18n.i18n.translate('xpack.synthetics.monitor.step.noDataFound', {
      defaultMessage: 'No data found'
    }),
    tableLayout: 'auto',
    itemId: "_id",
    itemIdToExpandedRowMap: testNowMode ? itemIdToExpandedRowMap : undefined
  }));
};
exports.BrowserStepsList = BrowserStepsList;
const StyleForStepStatus = ({
  step,
  textSize = 's',
  euiTheme,
  children
}) => {
  var _step$synthetics$step2, _step$synthetics3, _step$synthetics3$ste;
  const status = (0, _status_badge.parseBadgeStatus)((_step$synthetics$step2 = (_step$synthetics3 = step.synthetics) === null || _step$synthetics3 === void 0 ? void 0 : (_step$synthetics3$ste = _step$synthetics3.step) === null || _step$synthetics3$ste === void 0 ? void 0 : _step$synthetics3$ste.status) !== null && _step$synthetics$step2 !== void 0 ? _step$synthetics$step2 : '');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: {
      fontWeight: euiTheme.font.weight.bold,
      whiteSpace: 'nowrap'
    },
    size: textSize,
    color: euiTheme.colors[(0, _status_badge.getTextColorForMonitorStatus)(status)]
  }, children);
};
const MobileRowDetails = ({
  journeyStep,
  showStepNumber,
  showLastSuccessful,
  stepsLoading,
  isExpanded,
  isTestNowMode,
  euiTheme
}) => {
  var _journeyStep$syntheti, _journeyStep$syntheti2, _journeyStep$syntheti3, _journeyStep$syntheti4, _journeyStep$syntheti5, _journeyStep$syntheti6, _journeyStep$syntheti7, _journeyStep$syntheti8, _journeyStep$syntheti9, _journeyStep$syntheti10, _journeyStep$syntheti11, _journeyStep$syntheti12;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(StyleForStepStatus, {
    step: journeyStep,
    textSize: "relative",
    euiTheme: euiTheme
  }, showStepNumber && (_journeyStep$syntheti = journeyStep.synthetics) !== null && _journeyStep$syntheti !== void 0 && (_journeyStep$syntheti2 = _journeyStep$syntheti.step) !== null && _journeyStep$syntheti2 !== void 0 && _journeyStep$syntheti2.index ? `${journeyStep.synthetics.step.index}. ` : null, ' ', (_journeyStep$syntheti3 = journeyStep.synthetics) === null || _journeyStep$syntheti3 === void 0 ? void 0 : (_journeyStep$syntheti4 = _journeyStep$syntheti3.step) === null || _journeyStep$syntheti4 === void 0 ? void 0 : _journeyStep$syntheti4.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceEvenly",
    responsive: false,
    wrap: true,
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_journey_step_screenshot_container.JourneyStepScreenshotContainer, {
    checkGroup: journeyStep.monitor.check_group,
    initialStepNumber: (_journeyStep$syntheti5 = journeyStep.synthetics) === null || _journeyStep$syntheti5 === void 0 ? void 0 : (_journeyStep$syntheti6 = _journeyStep$syntheti5.step) === null || _journeyStep$syntheti6 === void 0 ? void 0 : _journeyStep$syntheti6.index,
    stepStatus: (_journeyStep$syntheti7 = journeyStep.synthetics.payload) === null || _journeyStep$syntheti7 === void 0 ? void 0 : _journeyStep$syntheti7.status,
    allStepsLoaded: !stepsLoading,
    retryFetchOnRevisit: true,
    size: _screenshot_size.THUMBNAIL_SCREENSHOT_SIZE_MOBILE,
    timestamp: journeyStep === null || journeyStep === void 0 ? void 0 : journeyStep['@timestamp']
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, [{
    title: RESULT_LABEL,
    description: /*#__PURE__*/_react.default.createElement(_result_details.ResultDetails, {
      testNowMode: isTestNowMode,
      step: journeyStep,
      pingStatus: (_journeyStep$syntheti8 = journeyStep === null || journeyStep === void 0 ? void 0 : (_journeyStep$syntheti9 = journeyStep.synthetics) === null || _journeyStep$syntheti9 === void 0 ? void 0 : (_journeyStep$syntheti10 = _journeyStep$syntheti9.step) === null || _journeyStep$syntheti10 === void 0 ? void 0 : _journeyStep$syntheti10.status) !== null && _journeyStep$syntheti8 !== void 0 ? _journeyStep$syntheti8 : 'skipped',
      isExpanded: isExpanded && !isTestNowMode
    })
  }, ...[showLastSuccessful ? {
    title: LAST_SUCCESSFUL,
    description: /*#__PURE__*/_react.default.createElement(_result_details_successful.ResultDetailsSuccessful, {
      step: journeyStep,
      isExpanded: isExpanded
    })
  } : {
    title: STEP_DURATION,
    description: /*#__PURE__*/_react.default.createElement(_step_duration_text.StepDurationText, {
      step: journeyStep
    })
  }]].map(({
    title,
    description
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    key: title,
    css: {
      maxWidth: 'fit-content'
    },
    direction: "row",
    alignItems: "baseline",
    gutterSize: "xs",
    responsive: false,
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, title), description))))), /*#__PURE__*/_react.default.createElement(_step_details_link.StepDetailsLinkIcon, {
    css: {
      marginLeft: 'auto'
    },
    checkGroup: journeyStep.monitor.check_group,
    stepIndex: (_journeyStep$syntheti11 = journeyStep.synthetics) === null || _journeyStep$syntheti11 === void 0 ? void 0 : (_journeyStep$syntheti12 = _journeyStep$syntheti11.step) === null || _journeyStep$syntheti12 === void 0 ? void 0 : _journeyStep$syntheti12.index,
    configId: journeyStep.config_id,
    asButton: true
  }));
};
const RESULT_LABEL = _i18n.i18n.translate('xpack.synthetics.monitor.result.label', {
  defaultMessage: 'Result'
});
const LAST_SUCCESSFUL = _i18n.i18n.translate('xpack.synthetics.monitor.result.lastSuccessful', {
  defaultMessage: 'Last successful'
});
const SCREENSHOT_LABEL = _i18n.i18n.translate('xpack.synthetics.monitor.screenshot.label', {
  defaultMessage: 'Screenshot'
});
const STEP_NAME = _i18n.i18n.translate('xpack.synthetics.monitor.stepName.label', {
  defaultMessage: 'Step name'
});
const STEP_DURATION = _i18n.i18n.translate('xpack.synthetics.monitor.step.duration.label', {
  defaultMessage: 'Duration'
});