"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STATUS_LABEL = exports.MonitorStatus = exports.BadgeStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BadgeStatus = ({
  status,
  isBrowserType
}) => {
  return !status || status === 'unknown' ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "default",
    "data-test-subj": "monitorLatestStatusPending"
  }, PENDING_LABEL) : status === 'up' ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "success",
    "data-test-subj": "monitorLatestStatusUp"
  }, isBrowserType ? SUCCESS_LABEL : UP_LABEL) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "danger",
    "data-test-subj": "monitorLatestStatusDown"
  }, isBrowserType ? FAILED_LABEL : DOWN_LABEL);
};
exports.BadgeStatus = BadgeStatus;
const MonitorStatus = ({
  loading,
  monitor,
  status,
  compressed = true
}) => {
  const isBrowserType = monitor.type === 'browser';
  const loadingContent = loading && !monitor;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    align: "left",
    compressed: compressed,
    listItems: [{
      title: STATUS_LABEL,
      description: loadingContent ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        lines: 1
      }) : /*#__PURE__*/_react.default.createElement(BadgeStatus, {
        status: status,
        isBrowserType: isBrowserType
      })
    }]
  });
};
exports.MonitorStatus = MonitorStatus;
const STATUS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorStatus.statusLabel', {
  defaultMessage: 'Status'
});
exports.STATUS_LABEL = STATUS_LABEL;
const FAILED_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorStatus.failedLabel', {
  defaultMessage: 'Failed'
});
const PENDING_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorStatus.pendingLabel', {
  defaultMessage: 'Pending'
});
const SUCCESS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorStatus.succeededLabel', {
  defaultMessage: 'Succeeded'
});
const UP_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorStatus.upLabel', {
  defaultMessage: 'Up'
});
const DOWN_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorStatus.downLabel', {
  defaultMessage: 'Down'
});