"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TlsTranslations = exports.AlertTlsComponent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertTlsComponent = ({
  ageThreshold,
  expirationThreshold,
  setAgeThreshold,
  setExpirationThreshold
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "none"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
  "aria-label": TlsTranslations.criteriaAriaLabel,
  color: "success",
  description: TlsTranslations.criteriaDescription,
  value: TlsTranslations.criteriaValue
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  "data-test-subj": "tlsExpirationThreshold"
}, /*#__PURE__*/_react.default.createElement(_public.ValueExpression, {
  value: expirationThreshold,
  onChangeSelectedValue: val => {
    setExpirationThreshold(val);
  },
  description: TlsTranslations.expirationDescription,
  errors: []
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  "data-test-subj": "tlsAgeExpirationThreshold"
}, /*#__PURE__*/_react.default.createElement(_public.ValueExpression, {
  value: ageThreshold,
  onChangeSelectedValue: val => {
    setAgeThreshold(val);
  },
  description: TlsTranslations.ageDescription,
  errors: []
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
}));
exports.AlertTlsComponent = AlertTlsComponent;
const TlsTranslations = {
  criteriaAriaLabel: _i18n.i18n.translate('xpack.synthetics.rules.tls.criteriaExpression.ariaLabel', {
    defaultMessage: 'An expression displaying the criteria for the monitors that are being watched by this alert'
  }),
  criteriaDescription: _i18n.i18n.translate('xpack.synthetics.alerts.tls.criteriaExpression.description', {
    defaultMessage: 'when',
    description: 'The context of this `when` is in the conditional sense, like "when there are three cookies, eat them all".'
  }),
  criteriaValue: _i18n.i18n.translate('xpack.synthetics.tls.criteriaExpression.value', {
    defaultMessage: 'matching monitor'
  }),
  expirationDescription: _i18n.i18n.translate('xpack.synthetics.tls.expirationExpression.description', {
    defaultMessage: 'has a certificate expiring within days: '
  }),
  ageDescription: _i18n.i18n.translate('xpack.synthetics.tls.ageExpression.description', {
    defaultMessage: 'or older than days: '
  })
};
exports.TlsTranslations = TlsTranslations;