"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewStatusStateCodec = exports.OverviewStatusMetaDataCodec = exports.OverviewStatusCodec = exports.OverviewPingCodec = exports.OverviewPendingStatusMetaDataCodec = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _observer = require("../ping/observer");
var _error_state = require("../ping/error_state");
var _ = require("..");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewPingCodec = t.intersection([t.interface({
  '@timestamp': t.string,
  summary: t.partial({
    down: t.number,
    up: t.number
  }),
  monitor: _.MonitorType,
  observer: _observer.ObserverCodec,
  config_id: t.string,
  agent: _.AgentType,
  url: _.UrlType,
  state: _error_state.ErrorStateCodec
}), t.partial({
  error: _.PingErrorType
})]);
exports.OverviewPingCodec = OverviewPingCodec;
const OverviewStatusMetaDataCodec = t.interface({
  monitorQueryId: t.string,
  configId: t.string,
  status: t.string,
  location: t.string,
  timestamp: t.string,
  ping: OverviewPingCodec
});
exports.OverviewStatusMetaDataCodec = OverviewStatusMetaDataCodec;
const OverviewPendingStatusMetaDataCodec = t.intersection([t.interface({
  monitorQueryId: t.string,
  configId: t.string,
  status: t.string,
  location: t.string
}), t.partial({
  timestamp: t.string,
  ping: OverviewPingCodec
})]);
exports.OverviewPendingStatusMetaDataCodec = OverviewPendingStatusMetaDataCodec;
const OverviewStatusCodec = t.interface({
  allMonitorsCount: t.number,
  disabledMonitorsCount: t.number,
  projectMonitorsCount: t.number,
  up: t.number,
  down: t.number,
  pending: t.number,
  disabledCount: t.number,
  upConfigs: t.record(t.string, OverviewStatusMetaDataCodec),
  downConfigs: t.record(t.string, OverviewStatusMetaDataCodec),
  pendingConfigs: t.record(t.string, OverviewPendingStatusMetaDataCodec),
  enabledMonitorQueryIds: t.array(t.string),
  disabledMonitorQueryIds: t.array(t.string),
  allIds: t.array(t.string)
});
exports.OverviewStatusCodec = OverviewStatusCodec;
const OverviewStatusStateCodec = t.intersection([OverviewStatusCodec, t.interface({
  allConfigs: t.record(t.string, OverviewStatusMetaDataCodec)
})]);
exports.OverviewStatusStateCodec = OverviewStatusStateCodec;