"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetApplication = void 0;
var _react = require("react");
var _lodash = require("lodash");
var _api = require("./api");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetApplication = ({
  toastNotifications
}) => {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const isCancelledRef = (0, _react.useRef)(false);
  const abortCtrlRef = (0, _react.useRef)(new AbortController());
  const getApplication = (0, _react.useCallback)(async ({
    appId,
    apiToken,
    apiUrl
  }) => {
    try {
      if ((0, _lodash.isEmpty)(appId) || (0, _lodash.isEmpty)(apiToken) || (0, _lodash.isEmpty)(apiUrl)) {
        return;
      }
      isCancelledRef.current = false;
      abortCtrlRef.current.abort();
      abortCtrlRef.current = new AbortController();
      setIsLoading(true);
      const data = await (0, _api.getApplication)({
        signal: abortCtrlRef.current.signal,
        appId,
        apiToken,
        url: apiUrl
      });
      if (!isCancelledRef.current) {
        setIsLoading(false);
        if (!data.fields) {
          // If the response was malformed and fields doesn't exist, show an error toast
          toastNotifications.addDanger({
            title: i18n.SW_GET_APPLICATION_API_ERROR(appId),
            text: i18n.SW_GET_APPLICATION_API_NO_FIELDS_ERROR
          });
          return;
        }
        return data;
      }
    } catch (error) {
      if (!isCancelledRef.current) {
        if (error.name !== 'AbortError') {
          toastNotifications.addDanger({
            title: i18n.SW_GET_APPLICATION_API_ERROR(appId),
            text: error.message
          });
        }
        setIsLoading(false);
      }
    }
  }, [toastNotifications]);
  return {
    isLoading,
    getApplication
  };
};
exports.useGetApplication = useGetApplication;