"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SERVICENOW_ITSM_TITLE = exports.SERVICENOW_ITSM_DESC = void 0;
exports.getServiceNowITSMConnectorType = getServiceNowITSMConnectorType;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _helpers = require("../lib/servicenow/helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const SERVICENOW_ITSM_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNowITSM.selectMessageText', {
  defaultMessage: 'Create an incident in ServiceNow ITSM.'
});
exports.SERVICENOW_ITSM_DESC = SERVICENOW_ITSM_DESC;
const SERVICENOW_ITSM_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNowITSM.connectorTypeTitle', {
  defaultMessage: 'ServiceNow ITSM'
});
exports.SERVICENOW_ITSM_TITLE = SERVICENOW_ITSM_TITLE;
function getServiceNowITSMConnectorType() {
  return {
    id: '.servicenow',
    iconClass: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./logo')))),
    selectMessage: SERVICENOW_ITSM_DESC,
    actionTypeTitle: SERVICENOW_ITSM_TITLE,
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../lib/servicenow/servicenow_connectors')))),
    validateParams: async actionParams => {
      var _actionParams$subActi;
      const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('../lib/servicenow/translations')));
      const errors = {
        'subActionParams.incident.short_description': new Array()
      };
      const validationResult = {
        errors
      };
      if (actionParams.subActionParams && actionParams.subActionParams.incident && !((_actionParams$subActi = actionParams.subActionParams.incident.short_description) !== null && _actionParams$subActi !== void 0 && _actionParams$subActi.length)) {
        errors['subActionParams.incident.short_description'].push(translations.TITLE_REQUIRED);
      }
      return validationResult;
    },
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./servicenow_itsm_params')))),
    customConnectorSelectItem: {
      getText: _helpers.getConnectorDescriptiveTitle,
      getComponent: _helpers.getSelectedConnectorIcon
    }
  };
}