"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApplicationRequiredCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sn_store_button = require("./sn_store_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const content = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.applicationRequiredCallout.content', {
  defaultMessage: 'Please go to the ServiceNow app store and install the application'
});
const ERROR_MESSAGE = _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.applicationRequiredCallout.errorMessage', {
  defaultMessage: 'Error message'
});
const ApplicationRequiredCalloutComponent = ({
  appId,
  message
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "m",
    iconType: "warning",
    "data-test-subj": "snApplicationCallout",
    color: "danger",
    title: _i18n.i18n.translate('xpack.stackConnectors.components.serviceNow.applicationRequiredCallout', {
      defaultMessage: 'Elastic ServiceNow App not installed'
    })
  }, /*#__PURE__*/_react.default.createElement("p", null, content), message && /*#__PURE__*/_react.default.createElement("p", null, ERROR_MESSAGE, ": ", message), /*#__PURE__*/_react.default.createElement(_sn_store_button.SNStoreButton, {
    color: "danger",
    appId: appId
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
const ApplicationRequiredCallout = /*#__PURE__*/(0, _react.memo)(ApplicationRequiredCalloutComponent);
exports.ApplicationRequiredCallout = ApplicationRequiredCallout;