"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _use_get_issue_types = require("./use_get_issue_types");
var _use_get_fields_by_issue_type = require("./use_get_fields_by_issue_type");
var _search_issues = require("./search_issues");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JiraParamsFields = ({
  actionConnector,
  actionParams,
  editAction,
  errors,
  index,
  messageVariables
}) => {
  var _actionConnector$id, _incident$issueType, _incident$issueType2, _incident$priority, _incident$summary, _incident$description;
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _public.useKibana)().services;
  const {
    incident,
    comments
  } = (0, _react.useMemo)(() => {
    var _actionParams$subActi;
    return (_actionParams$subActi = actionParams.subActionParams) !== null && _actionParams$subActi !== void 0 ? _actionParams$subActi : {
      incident: {},
      comments: []
    };
  }, [actionParams.subActionParams]);
  const actionConnectorRef = (0, _react.useRef)((_actionConnector$id = actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id) !== null && _actionConnector$id !== void 0 ? _actionConnector$id : '');
  const {
    isLoading: isLoadingIssueTypes,
    issueTypes
  } = (0, _use_get_issue_types.useGetIssueTypes)({
    http,
    toastNotifications: toasts,
    actionConnector
  });
  const {
    isLoading: isLoadingFields,
    fields
  } = (0, _use_get_fields_by_issue_type.useGetFieldsByIssueType)({
    http,
    toastNotifications: toasts,
    actionConnector,
    issueType: (_incident$issueType = incident.issueType) !== null && _incident$issueType !== void 0 ? _incident$issueType : ''
  });
  const editSubActionProperty = (0, _react.useCallback)((key, value) => {
    if (key === 'issueType') {
      return editAction('subActionParams', {
        incident: {
          issueType: value
        },
        comments
      }, index);
    }
    if (key === 'comments') {
      return editAction('subActionParams', {
        incident,
        comments: value
      }, index);
    }
    return editAction('subActionParams', {
      incident: {
        ...incident,
        [key]: value
      },
      comments
    }, index);
  }, [comments, editAction, incident, index]);
  const editComment = (0, _react.useCallback)((key, value) => {
    editSubActionProperty(key, [{
      commentId: '1',
      comment: value
    }]);
  }, [editSubActionProperty]);
  const {
    hasLabels,
    hasDescription,
    hasPriority,
    hasParent
  } = (0, _react.useMemo)(() => fields != null ? {
    hasLabels: Object.prototype.hasOwnProperty.call(fields, 'labels'),
    hasDescription: Object.prototype.hasOwnProperty.call(fields, 'description'),
    hasPriority: Object.prototype.hasOwnProperty.call(fields, 'priority'),
    hasParent: Object.prototype.hasOwnProperty.call(fields, 'parent')
  } : {
    hasLabels: false,
    hasDescription: false,
    hasPriority: false,
    hasParent: false
  }, [fields]);
  const issueTypesSelectOptions = (0, _react.useMemo)(() => {
    const doesIssueTypeExist = incident.issueType != null && issueTypes.length ? issueTypes.some(t => t.id === incident.issueType) : true;
    if ((!incident.issueType || !doesIssueTypeExist) && issueTypes.length > 0) {
      var _issueTypes$0$id;
      editSubActionProperty('issueType', (_issueTypes$0$id = issueTypes[0].id) !== null && _issueTypes$0$id !== void 0 ? _issueTypes$0$id : '');
    }
    return issueTypes.map(type => {
      var _type$id, _type$name;
      return {
        value: (_type$id = type.id) !== null && _type$id !== void 0 ? _type$id : '',
        text: (_type$name = type.name) !== null && _type$name !== void 0 ? _type$name : ''
      };
    });
  }, [editSubActionProperty, incident, issueTypes]);
  const prioritiesSelectOptions = (0, _react.useMemo)(() => {
    if (incident.issueType != null && fields != null) {
      const priorities = fields.priority != null ? fields.priority.allowedValues : [];
      const doesPriorityExist = priorities.some(p => p.name === incident.priority);
      if ((!incident.priority || !doesPriorityExist) && priorities.length > 0) {
        var _priorities$0$name;
        editSubActionProperty('priority', (_priorities$0$name = priorities[0].name) !== null && _priorities$0$name !== void 0 ? _priorities$0$name : '');
      }
      return priorities.map(p => {
        return {
          value: p.name,
          text: p.name
        };
      });
    }
    return [];
  }, [editSubActionProperty, fields, incident.issueType, incident.priority]);
  (0, _react.useEffect)(() => {
    if (!isLoadingFields && !hasPriority && incident.priority != null) {
      editSubActionProperty('priority', null);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [hasPriority, isLoadingFields]);
  const labelOptions = (0, _react.useMemo)(() => incident.labels ? incident.labels.map(label => ({
    label
  })) : [], [incident.labels]);
  (0, _react.useEffect)(() => {
    if (actionConnector != null && actionConnectorRef.current !== actionConnector.id) {
      actionConnectorRef.current = actionConnector.id;
      editAction('subActionParams', {
        incident: {},
        comments: []
      }, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionConnector]);
  (0, _react.useEffect)(() => {
    if (!actionParams.subAction) {
      editAction('subAction', 'pushToService', index);
    }
    if (!actionParams.subActionParams) {
      editAction('subActionParams', {
        incident: {},
        comments: []
      }, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionParams]);
  const areLabelsInvalid = errors['subActionParams.incident.labels'] != null && errors['subActionParams.incident.labels'] !== undefined && errors['subActionParams.incident.labels'].length > 0 && incident.labels !== undefined;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.jira.urgencySelectFieldLabel', {
      defaultMessage: 'Issue type'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    isLoading: isLoadingIssueTypes,
    disabled: isLoadingIssueTypes || isLoadingFields,
    "data-test-subj": "issueTypeSelect",
    options: issueTypesSelectOptions,
    value: (_incident$issueType2 = incident.issueType) !== null && _incident$issueType2 !== void 0 ? _incident$issueType2 : undefined,
    onChange: e => editSubActionProperty('issueType', e.target.value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), hasParent && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.jira.parentIssueSearchLabel', {
      defaultMessage: 'Parent issue'
    })
  }, /*#__PURE__*/_react.default.createElement(_search_issues.SearchIssues, {
    selectedValue: incident.parent,
    http: http,
    toastNotifications: toasts,
    actionConnector: actionConnector,
    onChange: parentIssueKey => {
      editSubActionProperty('parent', parentIssueKey);
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasPriority && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "priority-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.jira.severitySelectFieldLabel', {
      defaultMessage: 'Priority'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    isLoading: isLoadingFields,
    disabled: isLoadingIssueTypes || isLoadingFields,
    "data-test-subj": "prioritySelect",
    options: prioritiesSelectOptions,
    value: (_incident$priority = incident.priority) !== null && _incident$priority !== void 0 ? _incident$priority : undefined,
    onChange: e => {
      editSubActionProperty('priority', e.target.value);
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "summary-row",
    fullWidth: true,
    error: errors['subActionParams.incident.summary'],
    isInvalid: errors['subActionParams.incident.summary'] !== undefined && errors['subActionParams.incident.summary'].length > 0 && incident.summary !== undefined,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.jira.summaryFieldLabel', {
      defaultMessage: 'Summary (required)'
    })
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editSubActionProperty,
    messageVariables: messageVariables,
    paramsProperty: 'summary',
    inputTargetValue: (_incident$summary = incident.summary) !== null && _incident$summary !== void 0 ? _incident$summary : undefined,
    errors: errors['subActionParams.incident.summary']
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), hasLabels && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "labels-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.jira.impactSelectFieldLabel', {
      defaultMessage: 'Labels'
    }),
    error: errors['subActionParams.incident.labels'],
    isInvalid: areLabelsInvalid
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    noSuggestions: true,
    fullWidth: true,
    isLoading: isLoadingFields,
    isDisabled: isLoadingIssueTypes || isLoadingFields,
    selectedOptions: labelOptions,
    onCreateOption: searchValue => {
      const newOptions = [...labelOptions, {
        label: searchValue
      }];
      editSubActionProperty('labels', newOptions.map(newOption => newOption.label));
    },
    onChange: selectedOptions => {
      editSubActionProperty('labels', selectedOptions.map(selectedOption => selectedOption.label));
    },
    onBlur: () => {
      if (!incident.labels) {
        editSubActionProperty('labels', []);
      }
    },
    isClearable: true,
    "data-test-subj": "labelsComboBox",
    isInvalid: areLabelsInvalid
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), hasDescription && /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: editSubActionProperty,
    messageVariables: messageVariables,
    paramsProperty: 'description',
    inputTargetValue: (_incident$description = incident.description) !== null && _incident$description !== void 0 ? _incident$description : undefined,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.jira.descriptionTextAreaFieldLabel', {
      defaultMessage: 'Description'
    })
  }), /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: editComment,
    messageVariables: messageVariables,
    paramsProperty: 'comments',
    inputTargetValue: comments && comments.length > 0 ? comments[0].comment : undefined,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.jira.commentsTextAreaFieldLabel', {
      defaultMessage: 'Additional comments'
    })
  })));
};

// eslint-disable-next-line import/no-default-export
exports.default = JiraParamsFields;
module.exports = exports.default;