"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function getConnectorType() {
  return {
    id: '.index',
    iconClass: 'indexOpen',
    selectMessage: _i18n.i18n.translate('xpack.stackConnectors.components.index.selectMessageText', {
      defaultMessage: 'Index data into Elasticsearch.'
    }),
    actionTypeTitle: _i18n.i18n.translate('xpack.stackConnectors.components.index.connectorTypeTitle', {
      defaultMessage: 'Index data'
    }),
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./es_index_connector')))),
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./es_index_params')))),
    validateParams: async actionParams => {
      var _actionParams$documen;
      const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('./translations')));
      const errors = {
        documents: new Array(),
        indexOverride: new Array()
      };
      const validationResult = {
        errors
      };
      if (!((_actionParams$documen = actionParams.documents) !== null && _actionParams$documen !== void 0 && _actionParams$documen.length) || Object.keys(actionParams.documents[0]).length === 0) {
        errors.documents.push(translations.DOCUMENT_NOT_VALID);
      }
      if (actionParams.indexOverride) {
        if (!actionParams.indexOverride.startsWith(_public.ALERT_HISTORY_PREFIX)) {
          errors.indexOverride.push(_i18n.i18n.translate('xpack.stackConnectors.components.index.error.badIndexOverrideValue', {
            defaultMessage: 'Alert history index must begin with "{alertHistoryPrefix}".',
            values: {
              alertHistoryPrefix: _public.ALERT_HISTORY_PREFIX
            }
          }));
        }
        const indexSuffix = actionParams.indexOverride.replace(_public.ALERT_HISTORY_PREFIX, '');
        if (indexSuffix.length === 0) {
          errors.indexOverride.push(translations.HISTORY_NOT_VALID);
        }
      }
      return validationResult;
    }
  };
}