"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenAiSecretsSchema = exports.GenAiRunActionResponseSchema = exports.GenAiRunActionParamsSchema = exports.GenAiDashboardActionResponseSchema = exports.GenAiDashboardActionParamsSchema = exports.GenAiConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Connector schema
const GenAiConfigSchema = _configSchema.schema.object({
  apiProvider: _configSchema.schema.string(),
  apiUrl: _configSchema.schema.string()
});
exports.GenAiConfigSchema = GenAiConfigSchema;
const GenAiSecretsSchema = _configSchema.schema.object({
  apiKey: _configSchema.schema.string()
});

// Run action schema
exports.GenAiSecretsSchema = GenAiSecretsSchema;
const GenAiRunActionParamsSchema = _configSchema.schema.object({
  body: _configSchema.schema.string()
});
exports.GenAiRunActionParamsSchema = GenAiRunActionParamsSchema;
const GenAiRunActionResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  object: _configSchema.schema.string(),
  created: _configSchema.schema.number(),
  model: _configSchema.schema.string(),
  usage: _configSchema.schema.object({
    prompt_tokens: _configSchema.schema.number(),
    completion_tokens: _configSchema.schema.number(),
    total_tokens: _configSchema.schema.number()
  }),
  choices: _configSchema.schema.arrayOf(_configSchema.schema.object({
    message: _configSchema.schema.object({
      role: _configSchema.schema.string(),
      content: _configSchema.schema.string()
    }),
    finish_reason: _configSchema.schema.string(),
    index: _configSchema.schema.number()
  }))
}, {
  unknowns: 'ignore'
});

// Run action schema
exports.GenAiRunActionResponseSchema = GenAiRunActionResponseSchema;
const GenAiDashboardActionParamsSchema = _configSchema.schema.object({
  dashboardId: _configSchema.schema.string()
});
exports.GenAiDashboardActionParamsSchema = GenAiDashboardActionParamsSchema;
const GenAiDashboardActionResponseSchema = _configSchema.schema.object({
  available: _configSchema.schema.boolean()
});
exports.GenAiDashboardActionResponseSchema = GenAiDashboardActionResponseSchema;