"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformResults = transformResults;
var _lodash = _interopRequireDefault(require("lodash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Flatten agg results and get latest locations for each entity
function transformResults(results, dateField, geoField) {
  const buckets = _lodash.default.get(results, 'aggregations.shapes.buckets', {});
  const arrResults = _lodash.default.flatMap(buckets, (bucket, bucketKey) => {
    const subBuckets = _lodash.default.get(bucket, 'entitySplit.buckets', []);
    return _lodash.default.map(subBuckets, subBucket => {
      const locationFieldResult = _lodash.default.get(subBucket, `entityHits.hits.hits[0].fields["${geoField}"][0]`, '');
      const location = locationFieldResult ? _lodash.default.chain(locationFieldResult).split(', ').map(coordString => +coordString).reverse().value() : [];
      const dateInShape = _lodash.default.get(subBucket, `entityHits.hits.hits[0].fields["${dateField}"][0]`, null);
      const docId = _lodash.default.get(subBucket, `entityHits.hits.hits[0]._id`);
      return {
        location,
        shapeLocationId: bucketKey,
        entityName: subBucket.key,
        dateInShape,
        docId
      };
    });
  });
  const orderedResults = _lodash.default.orderBy(arrResults, ['entityName', 'dateInShape'], ['asc', 'desc'])
  // Get unique
  .reduce((accu, el) => {
    const {
      entityName,
      ...locationData
    } = el;
    if (entityName) {
      if (!accu.has(entityName)) {
        accu.set(entityName, []);
      }
      accu.get(entityName).push(locationData);
    }
    return accu;
  }, new Map());
  return orderedResults;
}