"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRuleTypes = registerRuleTypes;
var _geo_containment = require("./geo_containment");
var _threshold = require("./threshold");
var _es_query = require("./es_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerRuleTypes({
  ruleTypeRegistry,
  alerting
}) {
  ruleTypeRegistry.register((0, _geo_containment.getRuleType)());
  ruleTypeRegistry.register((0, _threshold.getRuleType)());
  ruleTypeRegistry.register((0, _es_query.getRuleType)(alerting));
}