"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityByExpression = void 0;
exports.getValidIndexPatternFields = getValidIndexPatternFields;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = _interopRequireDefault(require("lodash"));
var _single_field_select = require("../util_components/single_field_select");
var _expression_with_popover = require("../util_components/expression_with_popover");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENTITY_TYPES = ['string', 'number', 'ip'];
function getValidIndexPatternFields(fields) {
  return fields.filter(field => {
    const isSpecifiedSupportedField = ENTITY_TYPES.includes(field.type);
    const hasLeadingUnderscore = field.name.startsWith('_');
    const isAggregatable = !!field.aggregatable;
    return isSpecifiedSupportedField && isAggregatable && !hasLeadingUnderscore;
  });
}
const EntityByExpression = ({
  errors,
  entity,
  setAlertParamsEntity,
  indexFields,
  isInvalid
}) => {
  const usePrevious = value => {
    const ref = (0, _react.useRef)();
    (0, _react.useEffect)(() => {
      ref.current = value;
    });
    return ref.current;
  };
  const oldIndexFields = usePrevious(indexFields);
  const fields = (0, _react.useRef)({
    indexFields: []
  });
  (0, _react.useEffect)(() => {
    if (!_lodash.default.isEqual(oldIndexFields, indexFields)) {
      fields.current.indexFields = getValidIndexPatternFields(indexFields);
      if (!entity && fields.current.indexFields.length) {
        setAlertParamsEntity(fields.current.indexFields[0].name);
      }
    }
  }, [indexFields, oldIndexFields, setAlertParamsEntity, entity]);
  const indexPopover = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "entitySelect",
    fullWidth: true,
    error: errors.index
  }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
    placeholder: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.topHitsSplitFieldSelectPlaceholder', {
      defaultMessage: 'Select entity field'
    }),
    value: entity,
    onChange: _entity => _entity && setAlertParamsEntity(_entity),
    fields: fields.current.indexFields
  }));
  return /*#__PURE__*/_react.default.createElement(_expression_with_popover.ExpressionWithPopover, {
    isInvalid: isInvalid,
    value: entity,
    defaultValue: 'Select entity field',
    popoverContent: indexPopover,
    expressionDescription: _i18n.i18n.translate('xpack.stackAlerts.geoContainment.entityByLabel', {
      defaultMessage: 'by'
    })
  });
};
exports.EntityByExpression = EntityByExpression;