"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HDFSDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HDFSDetails = ({
  repository
}) => {
  const {
    settings
  } = repository;
  const {
    uri,
    path,
    loadDefaults,
    compress,
    chunkSize,
    readonly,
    maxSnapshotBytesPerSec,
    maxRestoreBytesPerSec,
    'security.principal': securityPrincipal,
    ...rest
  } = settings;
  const listItems = [{
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryDetails.typeHDFS.uriLabel",
      defaultMessage: "URI"
    }),
    description: uri || ''
  }, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryDetails.typeHDFS.pathLabel",
      defaultMessage: "Path"
    }),
    description: path || ''
  }];
  if (loadDefaults !== undefined) {
    listItems.push({
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryDetails.typeHDFS.loadDefaultsLabel",
        defaultMessage: "Load defaults"
      }),
      description: String(loadDefaults)
    });
  }
  if (compress !== undefined) {
    listItems.push({
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryDetails.typeHDFS.compressLabel",
        defaultMessage: "Snapshot compression"
      }),
      description: String(compress)
    });
  }
  if (chunkSize !== undefined) {
    listItems.push({
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryDetails.typeHDFS.chunkSizeLabel",
        defaultMessage: "Chunk size"
      }),
      description: String(chunkSize)
    });
  }
  if (maxSnapshotBytesPerSec !== undefined) {
    listItems.push({
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryDetails.typeHDFS.maxSnapshotBytesLabel",
        defaultMessage: "Max snapshot bytes per second"
      }),
      description: maxSnapshotBytesPerSec
    });
  }
  if (maxRestoreBytesPerSec !== undefined) {
    listItems.push({
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryDetails.typeHDFS.maxRestoreBytesLabel",
        defaultMessage: "Max restore bytes per second"
      }),
      description: maxRestoreBytesPerSec
    });
  }
  if (readonly !== undefined) {
    listItems.push({
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryDetails.typeHDFS.readonlyLabel",
        defaultMessage: "Read-only"
      }),
      description: String(readonly)
    });
  }
  if (securityPrincipal !== undefined) {
    listItems.push({
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.repositoryDetails.typeHDFS.securityPrincipalLabel",
        defaultMessage: "Security principal"
      }),
      description: securityPrincipal
    });
  }
  Object.keys(rest).forEach(key => {
    listItems.push({
      title: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, key),
      description: String(settings[key])
    });
  });
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.repositoryDetails.settingsTitle",
    defaultMessage: "Settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    listItems: listItems
  }));
};
exports.HDFSDetails = HDFSDetails;