"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SharePlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("./index.scss");
var _services = require("./services");
var _url_service = require("../common/url_service");
var _url_service2 = require("./url_service");
var _short_url_client_factory = require("./url_service/short_urls/short_url_client_factory");
var _legacy_short_url_locator = require("../common/url_service/locators/legacy_short_url_locator");
var _short_url_redirect_locator = require("../common/url_service/locators/short_url_redirect_locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class SharePlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "shareMenuRegistry", new _services.ShareMenuRegistry());
    (0, _defineProperty2.default)(this, "shareContextMenu", new _services.ShareMenuManager());
    (0, _defineProperty2.default)(this, "redirectManager", void 0);
    (0, _defineProperty2.default)(this, "url", void 0);
    (0, _defineProperty2.default)(this, "anonymousAccessServiceProvider", void 0);
    this.initializerContext = initializerContext;
  }
  setup(core) {
    const {
      http
    } = core;
    const {
      basePath
    } = http;
    this.url = new _url_service.UrlService({
      baseUrl: basePath.get(),
      version: this.initializerContext.env.packageInfo.version,
      navigate: async ({
        app,
        path,
        state
      }, {
        replace = false
      } = {}) => {
        const [start] = await core.getStartServices();
        await start.application.navigateToApp(app, {
          path,
          state,
          replace
        });
      },
      getUrl: async ({
        app,
        path
      }, {
        absolute
      }) => {
        const start = await core.getStartServices();
        const url = start[0].application.getUrlForApp(app, {
          path,
          absolute
        });
        return url;
      },
      shortUrls: ({
        locators
      }) => new _short_url_client_factory.BrowserShortUrlClientFactory({
        http,
        locators
      })
    });
    this.url.locators.create(new _legacy_short_url_locator.LegacyShortUrlLocatorDefinition());
    this.url.locators.create(new _short_url_redirect_locator.ShortUrlRedirectLocatorDefinition());
    this.redirectManager = new _url_service2.RedirectManager({
      url: this.url
    });
    this.redirectManager.registerLocatorRedirectApp(core);
    this.redirectManager.registerLegacyShortUrlRedirectApp(core);
    return {
      ...this.shareMenuRegistry.setup(),
      url: this.url,
      navigate: options => this.redirectManager.navigate(options),
      setAnonymousAccessServiceProvider: provider => {
        if (this.anonymousAccessServiceProvider) {
          throw new Error('Anonymous Access service provider is already set.');
        }
        this.anonymousAccessServiceProvider = provider;
      }
    };
  }
  start(core) {
    const sharingContextMenuStart = this.shareContextMenu.start(core, this.url, this.shareMenuRegistry.start(), this.anonymousAccessServiceProvider);
    return {
      ...sharingContextMenuStart,
      url: this.url,
      navigate: options => this.redirectManager.navigate(options)
    };
  }
}
exports.SharePlugin = SharePlugin;