"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaURL = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// TODO: Replace this logic with KibanaURL once it is available.
// https://github.com/elastic/kibana/issues/64497
class KibanaURL {
  constructor(path) {
    (0, _defineProperty2.default)(this, "path", void 0);
    (0, _defineProperty2.default)(this, "appName", void 0);
    (0, _defineProperty2.default)(this, "appPath", void 0);
    const match = path.match(/^.*\/app\/([^\/#]+)(.+)$/);
    if (!match) {
      throw new Error('Unexpected URL path.');
    }
    const [, appName, appPath] = match;
    if (!appName || !appPath) {
      throw new Error('Could not parse URL path.');
    }
    this.path = path;
    this.appName = appName;
    this.appPath = appPath;
  }
}
exports.KibanaURL = KibanaURL;