"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSessionViewLazy = exports.getIndexPattern = exports.ENDPOINT_INDEX = exports.DEFAULT_INDEX = exports.CLOUD_DEFEND_INDEX = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactQuery = require("@tanstack/react-query");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
// Initializing react-query
const queryClient = new _reactQuery.QueryClient();
const SessionViewLazy = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../components/session_view'))));
const SUPPORTED_PACKAGES = ['endpoint', 'cloud_defend'];
const INDEX_REGEX = new RegExp(`([a-z0-9_-]+\:)?[a-z0-9\-.]*(${SUPPORTED_PACKAGES.join('|')})`, 'i');
const DEFAULT_INDEX = 'logs-*';
exports.DEFAULT_INDEX = DEFAULT_INDEX;
const CLOUD_DEFEND_INDEX = 'logs-cloud_defend.*';
exports.CLOUD_DEFEND_INDEX = CLOUD_DEFEND_INDEX;
const ENDPOINT_INDEX = 'logs-endpoint.events.process*';

// Currently both logs-endpoint.events.process* and logs-cloud_defend.process* are valid sources for session data.
// To avoid cross cluster searches, the original index of the event is used to infer the index to find data for the
// rest of the session.
exports.ENDPOINT_INDEX = ENDPOINT_INDEX;
const getIndexPattern = eventIndex => {
  if (!eventIndex) {
    return DEFAULT_INDEX;
  }
  const match = eventIndex.match(INDEX_REGEX);
  const cluster = match === null || match === void 0 ? void 0 : match[1];
  const clusterStr = cluster ? `${cluster}` : '';
  const service = match === null || match === void 0 ? void 0 : match[2];
  let index = DEFAULT_INDEX;
  if (service === 'endpoint') {
    index = ENDPOINT_INDEX;
  } else if (service === 'cloud_defend') {
    index = CLOUD_DEFEND_INDEX;
  }
  return clusterStr + index;
};
exports.getIndexPattern = getIndexPattern;
const getSessionViewLazy = props => {
  const index = getIndexPattern(props.index);
  return /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(SessionViewLazy, (0, _extends2.default)({}, props, {
    index: index
  }))));
};
exports.getSessionViewLazy = getSessionViewLazy;