"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _serverlessProjectSwitcher = require("@kbn/serverless-project-switcher");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ServerlessPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    this.initializerContext = initializerContext;
    this.config = this.initializerContext.config.get();
  }
  setup(_core, _dependencies) {
    return {};
  }
  start(core, dependencies) {
    const {
      developer
    } = this.config;
    const {
      management
    } = dependencies;
    if (developer && developer.projectSwitcher && developer.projectSwitcher.enabled) {
      const {
        currentType
      } = developer.projectSwitcher;
      core.chrome.navControls.registerRight({
        mount: target => this.mountProjectSwitcher(target, core, currentType)
      });
    }
    core.chrome.setChromeStyle('project');
    management.setIsSidebarEnabled(false);

    // Casting the "chrome.projects" service to an "internal" type: this is intentional to obscure the property from Typescript.
    const {
      project
    } = core.chrome;
    return {
      setSideNavComponent: sideNavigationComponent => project.setSideNavComponent(sideNavigationComponent),
      setNavigation: projectNavigation => project.setNavigation(projectNavigation),
      setBreadcrumbs: (breadcrumbs, params) => project.setBreadcrumbs(breadcrumbs, params),
      setProjectHome: homeHref => project.setHome(homeHref),
      getActiveNavigationNodes$: () => core.chrome.project.getActiveNavigationNodes$()
    };
  }
  stop() {}
  mountProjectSwitcher(targetDomElement, coreStart, currentProjectType) {
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: coreStart.theme.theme$
    }, /*#__PURE__*/_react.default.createElement(_serverlessProjectSwitcher.ProjectSwitcherKibanaProvider, {
      coreStart,
      projectChangeAPIUrl: _common.API_SWITCH_PROJECT
    }, /*#__PURE__*/_react.default.createElement(_serverlessProjectSwitcher.ProjectSwitcher, {
      currentProjectType
    })))), targetDomElement);
    return () => _reactDom.default.unmountComponentAtNode(targetDomElement);
  }
}
exports.ServerlessPlugin = ServerlessPlugin;